from django.urls import path, include
from rest_framework import routers
from django.conf.urls import url
from rest_framework.urlpatterns import format_suffix_patterns

from app.applicationlayer.ams.asset_group import views as assetgroup
from app.applicationlayer.ams.ams_privilege import views as amsprivilege
from app.applicationlayer.ams.ams_user_type.views import AMSUserTypeViewSet
from app.applicationlayer.ams.asset_type import views as assettype
from app.applicationlayer.ams.asset.views import AMSAssetViewSet
from app.applicationlayer.ams.asset_stock.views import AMSAssetStockViewSet
from app.applicationlayer.ams.report_type.views import AMSReportTypeViewset
from app.applicationlayer.ams.report.views import AMSReportViewset

router = routers.DefaultRouter()

router.register(r'asset-group', assetgroup.AssetGroupViewset)
router.register(r'asset-type', assettype.AssetTypeViewset)
router.register(r'ams-privilege', amsprivilege.AMSPrivilegeViewSet)
router.register(r'assets', AMSAssetViewSet)
router.register(r'assets-stock-list', AMSAssetStockViewSet)
router.register(r'report-type', AMSReportTypeViewset)
router.register(r'report', AMSReportViewset)

urlpatterns = [
    path('', include(router.urls)),
    url(r'^ams-user-types/$', AMSUserTypeViewSet.as_view(), name="ams-user-types"),
]