from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class AMSReportTypeSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['added_by'] = instance.created_by.name
        return ret

    class Meta:
        model = models.AMSReportType
        fields = '__all__'