from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class AssetTypeSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['asset_count'] = instance.ams_asset_type.count()
        ret['asset_stock_count'] = 0
        
        return ret

    class Meta:
        model = models.AMSAssetType
        fields = '__all__'
        read_only_fields = ['created', 'created_by', 'code']