from .base import *
import configparser

DEBUG = False

ALLOWED_HOSTS = ['*']

SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')
SECURE_SSL_REDIRECT = True
SESSION_COOKIE_SECURE = True
CSRF_COOKIE_SECURE = True

REST_FRAMEWORK = {
    'EXCEPTION_HANDLER': 'rest_framework.views.exception_handler',
    'UNAUTHENTICATED_USER': None,
    'DEFAULT_RENDERER_CLASSES': (
        'rest_framework.renderers.JSONRenderer',
    ),
}

config = configparser.ConfigParser()
config.read('env.ini')

DATABASES = {
    'default': {
        'ENGINE': config['PRODUCTION']['DATABASE_ENGINE'],
        'NAME': config['PRODUCTION']['DATABASE_NAME'],
        'USER': config['PRODUCTION']['DATABASE_USER'],
        'PASSWORD': config['PRODUCTION']['DATABASE_PASSWORD'],
        'HOST': config['PRODUCTION']['DATABASE_HOST'],
        'PORT': config['PRODUCTION']['DATABASE_PORT'],
    }
}

AUTHENTICATOR_IP = config['SERVICE']['AUTHENTICATOR_IP']
AUTHENTICATOR_PATH = '/api/v1/authenticator'

VALIDATE_TOKEN_URL = f'http://{AUTHENTICATOR_IP}{AUTHENTICATOR_PATH}/validate-token/'
