from rest_framework.views import APIView
from rest_framework.response import Response
from .utils import Helper
from django.conf import settings
from django.http import FileResponse

class APIGatewayList(APIView):

    def _response(self, request, **kwargs):
        service = kwargs.get('service')
        endpoint_url = kwargs.get('endpoint_url')
        api = Helper().get_endpoint(request, service, endpoint_url)

        if str(type(api)) == "<class 'requests.models.Response'>":

            # varifile = f"{settings.BASE_DIR}/test.xlsx"

            # filedesciptor = open(varifile, 'wb')
            # filedesciptor.write(api.content)
            # filedesciptor.close()

            # filer = open(varifile, 'rb')

            return FileResponse(api, as_attachment=True)

        return Response(api['data'],
                        status=api['status_code'],
                        headers=api['headers'])

    def get(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def post(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def delete(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)


class APIGatewaySlugDetail(APIView):

    def _response(self, request, **kwargs):
        service = kwargs.get('service')
        endpoint_url = kwargs.get('endpoint_url')
        slug = kwargs.get('slug')
        if slug == 'archived':
            slug = 'archived'
        else:
            slug = 'slug'
        api = Helper().get_endpoint(
            request, service, f"{endpoint_url}/{slug}")
        return Response(api['data'],
                        status=api['status_code'],
                        headers=api['headers'])

    def get(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def put(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def patch(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def delete(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)


class APIGatewaySlugModelDetail(APIView):

    def _response(self, request, **kwargs):
        service = kwargs.get('service')
        endpoint_url = kwargs.get('endpoint_url')
        api = Helper().get_endpoint(
            request, service, f"{endpoint_url}/slug/model")
        return Response(api['data'],
                        status=api['status_code'],
                        headers=api['headers'])

    def get(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def post(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def put(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def patch(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def delete(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)
