"""ams URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include
from django.conf.urls import url
from app.applicationlayer.management.notification import views as notifview


urlpatterns = [
    # path('admin/', admin.site.urls),
    path('api-auth/', include('rest_framework.urls')),
    path('api/v1/auth/', include('app.accesslayer.urls')),
    path('api/v1/management/', include('app.applicationlayer.urls')),
    path('api/v1/master/', include('app.applicationlayer.master.urls')),
    url(r'^chat/$', notifview.index, name='index'),
    url(r'^chat/(?P<room_name>[^/]+)/$', notifview.room, name='room'),
]
