# Generated by Django 2.2 on 2019-09-03 13:55

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('user_type', models.CharField(choices=[('SU', 'SU'), ('OUA', 'OUA'), ('CUA', 'CUA'), ('DUA', 'DUA'), ('USR', 'USR')], default='USR', max_length=100)),
                ('code', models.CharField(default='acct', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('username', models.CharField(max_length=255, unique=True)),
                ('password', models.CharField(blank=True, max_length=255, null=True)),
                ('contact_no', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(max_length=255)),
            ],
            options={
                'db_table': 'auth_user',
            },
        ),
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
            ],
            options={
                'db_table': 'applications',
            },
        ),
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.FileField(max_length=255, null=True, upload_to='file_attachments/')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'db_table': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(default='com', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('contact_details', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'companies',
            },
        ),
        migrations.CreateModel(
            name='EntityLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('action', models.CharField(choices=[('Add', 'Add'), ('Update', 'Update'), ('DELETED', 'DELETED')], default='Add', max_length=50)),
                ('entity', models.CharField(choices=[('USER', 'USER'), ('APPLICATION', 'APPLICATION'), ('COMPANY', 'COMPANY'), ('DEPARTMENT', 'DEPARTMENT'), ('MODULE', 'MODULE')], default='Add', max_length=50)),
                ('row_id', models.IntegerField()),
                ('fromValue', models.TextField(blank=True, null=True)),
                ('toValue', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'entity_logs',
            },
        ),
        migrations.CreateModel(
            name='Permission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255, null=True)),
                ('code', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('description', models.CharField(max_length=255, null=True)),
            ],
            options={
                'db_table': 'permissions',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('code', models.CharField(default='role', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'roles',
            },
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('ref', models.CharField(max_length=10)),
                ('code', models.CharField(max_length=10, unique=True)),
                ('name', models.CharField(max_length=10, unique=True)),
                ('description', models.CharField(max_length=100, null=True)),
            ],
            options={
                'db_table': 'status_set',
            },
        ),
        migrations.CreateModel(
            name='UserImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('image', models.ImageField(max_length=255, null=True, upload_to='user_images/')),
                ('is_primary', models.BooleanField(default=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='user_images', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'auth_user_images',
            },
        ),
        migrations.CreateModel(
            name='RolePermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('permission', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='role_permissions', to='entities.Permission')),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='role_permissions', to='entities.Role')),
            ],
            options={
                'db_table': 'role_permissions',
            },
        ),
        migrations.CreateModel(
            name='Module',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(default='mod', max_length=255, unique=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('parent', models.IntegerField()),
                ('sort_id', models.IntegerField()),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='modules', to='entities.Application')),
            ],
            options={
                'db_table': 'modules',
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(default='dept', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='companies', to='entities.Company')),
            ],
            options={
                'db_table': 'departments',
            },
        ),
        migrations.CreateModel(
            name='AuthToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ref', models.CharField(max_length=255)),
                ('token', models.TextField()),
                ('passcode', models.CharField(max_length=255)),
                ('timeout', models.IntegerField()),
                ('is_active', models.BooleanField(default=False)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='auth_access_token', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'auth_access_token',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='application',
            field=models.ManyToManyField(to='entities.Application'),
        ),
        migrations.AddField(
            model_name='user',
            name='department',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.PROTECT, related_name='department_users', to='entities.Department'),
        ),
        migrations.AddField(
            model_name='user',
            name='doa',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='doa_users', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
    ]
