from rest_framework.views import APIView
from rest_framework.response import Response
from app.entities import enums


class UserTypeViewSet(APIView):

    def get(self, request, format=None):
        enums_super = enums.UserTypeEnum.SUPER_USER.value
        enums_OUA = enums.UserTypeEnum.OVERALL_USER_ADMIN.value
        enums_company = enums.UserTypeEnum.COMPANY_USER_ADMIN.value
        enums_department = enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.value
        enums_user = enums.UserTypeEnum.USER.value
        
        data = {
            'Super user': enums_super,
            'Overall user admin': enums_OUA,
            "Company user admin": enums_company,
            "Department user admin": enums_department,
            "user": enums_user
        }

        if self.request.user.user_type == enums_OUA:
            del data['Super user']
            del data['Overall user admin']
        elif self.request.user.user_type == enums_company:
            del data['Super user']
            del data['Overall user admin']
            del data['Company user admin']
        elif self.request.user.user_type == enums_department:
            del data['Super User']
            del data['Overall user admin']
            del data['Company user admin']
            del data['Department user admin']

        return Response(data)
