from .base import *
import configparser

DEBUG = True

ALLOWED_HOSTS = ['*']

config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)

DATABASES = {
    'default': {
        'ENGINE': config['UAT']['DATABASE_ENGINE'],
        'NAME': config['UAT']['DATABASE_NAME'],
        'USER': config['UAT']['DATABASE_USER'],
        'PASSWORD': config['UAT']['DATABASE_PASSWORD'],
        'HOST': config['UAT']['DATABASE_HOST'],
        'PORT': config['UAT']['DATABASE_PORT'],
    }
}

# ****************
# PROGRAM SETTINGS
# ****************
SESSION_TIMEOUT = config['UAT']['SESSION_TIMEOUT']
FRONT_END_URL = config['UAT']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['UAT']['AUTH_ACCESSS_TOKEN_TIMEOUT']
USER_DEFAULT_PASSWORD = config['UAT']['USER_DEFAULT_PASSWORD']
REALTIMESERVER_IP = config['NOTIFICATION']['REALTIMESERVER_IP']