from rest_framework import viewsets as meviewsets
from rest_framework.viewsets import ReadOnlyModelViewSet
from drf_renderer_xlsx.mixins import XLSXFileMixin
from drf_renderer_xlsx.renderers import XLSXRenderer
from app.entities.models import (
    ChangeRequestFormHeader,
    ChangeRequestFormApprovers,
    ChangeRequestFormStakeHolders
)
# from app.applicationlayer.form_listing_ import headers
from app.applicationlayer.cms.form.download.serializers import headers
from django.db.models import CharField, Value
from django.db.models import Q
from rest_framework.response import Response
from rest_framework.permissions import AllowAny
# from cms.applicationlayer.utilities import logged_user


class DownloadRequest(XLSXFileMixin, ReadOnlyModelViewSet):
    queryset = ChangeRequestFormHeader.objects.all()
    serializer_class = headers
    renderer_classes = (XLSXRenderer,)
    filename = 'Change Request Form.xlsx'
    permission_classes = (AllowAny,)

    def list(self, request, *args, **kwargs):
        # id_number = self.request.META.get('HTTP_ACCOUNT_NO')
        # id_number = 'USER-20190923-0000001'
        # print(request.user.code)
        id_number = request.user.code

        # id_number = self.request.query_params.get('id_number')



        # approver = ChangeRequestFormApprovers.objects.filter(
        #             Q(user=id_number) &
        #             Q(deleted_at=None)
        # )
        # approver = [data['form_code'] for data in approver]
        # stake = ChangeRequestFormStakeHolders.objects.filter(
        #                 Q(user=id_number) &
        #                 Q(deleted_at=None)
        # )
        # stake = [data['form_code'] for data in stake]
        data = ChangeRequestFormHeader.objects.filter(
            Q(frm_approvers__user__code=id_number) |
            Q(requested_by_user=id_number) |
            Q(frm_stakes__user__code=id_number)
        ).distinct()
        # print(headers)
        # print(headers)
        # headers = [data['form_code'] for data in headers]
        # form_code = stake + approver + headers
        # self.queryset = ChangeRequestFormHeader.objects.filter(
        #     form_code__in=form_code,
        #     deleted_at=None,
        # )
        # exclude = self.queryset.filter(
        #     status='DRAFT',
        #     requested_by_user__ne=id_number
        # )
        # exclude = [data['form_code'] for data in exclude]

        # self.queryset = headers
        # print(data)
        serializer = self.get_serializer(data, many=True)
        # print(serializer.data)
        return Response(serializer.data)

    column_header = {
        'titles': [
            "Name",
            "Company Request To",
            "Department Requested To",
            "Requested By",
            "Status",
            "Priority Level",
            "Action"
            "Date Modified",
            "Date Required"
        ],
        'column_width': [17, 30, 17],
        'height': 25,
        'style': {
            'alignment': {
                'horizontal': 'center',
                'vertical': 'center',
                'wrapText': False,
                'shrink_to_fit': True,
            },
            'border_side': {
                'border_style': 'thin',
                'color': 'FF000000',
            },
            'font': {
                'name': 'Arial',
                'size': 14,
                'bold': True,
                'color': 'FF000000',
            },
        },
    }
