from app.entities import models
from rest_framework import serializers


class headers(serializers.ModelSerializer):
    def to_representation(self, instance):
        setattr(
            instance, 'created', instance.created.strftime('%Y-%m-%d-%H:%M:%S')
        )
        setattr(
            instance, 'requested_to_target_date',
            instance.requested_to_target_date.strftime('%Y-%m-%d-%H:%M:%S')
        )
        return super().to_representation(instance)

    class Meta:
        model = models.ChangeRequestFormHeader
        fields = (
            'requested_to_template_name',
            'company_desc',
            'department_desc',
            'requested_desc',
            'status',
            'requested_to_priority',
            'created',
            'requested_to_target_date'
        )
