from rest_framework import serializers
from app.entities import models
from app.applicationlayer.utils import model_to_dict


class ChangeRequestTemplateApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        try:
            ret = super().to_representation(instance)

            if instance.user:
                user_object = {
                    "id": instance.user.id,
                    "name": instance.user.name,
                    "username": instance.user.username,
                    "code": instance.user.code,
                    "email": instance.user.email,
                    "contact_no": instance.user.contact_no
                }

                ret['company'] = {
                    "id": instance.user.department.company.id,
                    "code": instance.user.department.company.code,
                    "name": instance.user.department.company.name
                }
                ret['department'] = {
                    "id": instance.user.department.id,
                    "code": instance.user.department.code,
                    "name": instance.user.department.name
                }
                ret['user'] = user_object
                ret['editable_user'] = False
                ret['editable_comp'] = False
                ret['editable_dept'] = False
            else:
                ret['editable_user'] = True
                ret['editable_comp'] = True
                ret['editable_dept'] = True

            if instance.company:
                
                ret['company'] = {
                    "id": instance.company.id,
                    "code": instance.company.code,
                    "name": instance.company.name
                }
                ret['editable_comp'] = False
            else:
                ret['editable_comp'] = True

            if instance.department:

                ret['department'] = {
                    "id": instance.department.id,
                    "code": instance.department.code,
                    "name": instance.department.name
                }
                ret['editable_dept'] = False
            else:
                ret['editable_dept'] = True
            
            if instance.delegation.lower() == 'requestor':

                ret['editable_user'] = False
                ret['editable_comp'] = False
                ret['editable_dept'] = False

            return ret
        except Exception as e:

            ret['editable_user'] = True
            ret['editable_comp'] = True
            ret['editable_dept'] = True
            
            return ret

    class Meta:
        model = models.ChangeRequestTemplateApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']