"""
Django settings for ams project.

Generated by 'django-admin startproject' using Django 2.2.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import os
import configparser


config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(
                os.path.dirname(
                    os.path.dirname(
                        os.path.abspath(__file__))))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'w!dkk7gc*dk#4!6ow3s1wc32%_yp$=osgybm=n0vw6k1j^sqo&'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rest_framework',
    'corsheaders',

    'rest_framework.authtoken',
    'app.accesslayer',
    'app.entities',
    'channels',

]

MIDDLEWARE = [
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',

    'app.middleware.current_user.main.CurrentUserMiddleware'
]

ROOT_URLCONF = 'config.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'config.wsgi.application'

ASGI_APPLICATION = "config.routing.application"

AUTH_USER_MODEL = 'entities.User'

# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Asia/Singapore'

USE_I18N = True

USE_L10N = True

USE_TZ = False


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, "static")

MEDIA_ROOT = os.path.join(BASE_DIR, 'media')
MEDIA_URL = '/media/'

# CORS_ORIGIN_ALLOW_ALL = True

REST_SESSION_LOGIN = True

REST_FRAMEWORK = {
    'DEFAULT_RENDERER_CLASSES': [
        'rest_framework.renderers.JSONRenderer',
        'rest_framework.renderers.AdminRenderer',
        'rest_framework.renderers.BrowsableAPIRenderer',
        'drf_renderer_xlsx.renderers.XLSXRenderer',
    ],

    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticated',
        'rest_framework.permissions.AllowAny',
    ),

    'DEFAULT_AUTHENTICATION_CLASSES': (
        # 'rest_framework.authentication.TokenAuthentication',
        'app.accesslayer.authentication.AppTokenAuthentication',
        'rest_framework.authentication.BasicAuthentication',
        'rest_framework.authentication.SessionAuthentication',
    ),

    'DEFAULT_FILTER_BACKENDS': ('django_filters.rest_framework.DjangoFilterBackend',),
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
    'EXCEPTION_HANDLER': 'rest_framework.views.exception_handler',
    # 'EXCEPTION_HANDLER': 'app.datalayer.serializer_handler.custom_exception_handler',
    'PAGE_SIZE': 10
}

EMAIL_TEMPLATES_ROOT = os.path.join(BASE_DIR, "app/helper/email_service/templates")
EMAIL_HOST = 'email-smtp.us-west-2.amazonaws.com'
EMAIL_PORT = 587
EMAIL_HOST_USER = 'AKIAIPRWQKYV6N5SMLUA'
EMAIL_HOST_PASSWORD = 'ApK1dtH2qpT/oMl9MEauFvyN9XZDQ1fjzd8TumIs71NG'
EMAIL_USE_SSL = False
EMAIL_USE_TLS = True
EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_DEFAULT_SENDER = 'rms.noreply@oneberrysystem.com'

# EMAIL_TEMPLATES_ROOT = os.path.join(BASE_DIR, "app/helper/email_service/templates")


# EMAIL_HOST = config['DEV']['EMAIL_HOST']
# EMAIL_PORT = config['DEV']['EMAIL_PORT']
# EMAIL_HOST_USER = config['DEV']['EMAIL_PORT']
# EMAIL_HOST_PASSWORD = config['DEV']['EMAIL_HOST_PASSWORD']
# EMAIL_USE_SSL = config['DEV']['EMAIL_USE_SSL']
# EMAIL_USE_TLS = config['DEV']['EMAIL_USE_TLS']
# EMAIL_BACKEND = config['DEV']['EMAIL_BACKEND']
# EMAIL_DEFAULT_SENDER = config['DEV']['EMAIL_DEFAULT_SENDER']

# EMAIL_HOST = 'email-smtp.us-west-2.amazonaws.com'
# EMAIL_PORT = 587
# EMAIL_HOST_USER = 'AKIAYA4XVX5XFZHRQATF'
# EMAIL_HOST_PASSWORD = 'BIOG15v+WTbTiBtPKkn+LCjg0UHqO3nLFQezh4pi6g3y'
# EMAIL_USE_SSL = False
# EMAIL_USE_TLS = True
# EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
# EMAIL_DEFAULT_SENDER = 'noreply@rms-hub.com'
