from app.entities.models import AMSAsset
from rest_framework import viewsets, status
from rest_framework.response import Response
from django_filters import rest_framework as filters
from django_filters.rest_framework import DjangoFilterBackend
from rest_framework.filters import SearchFilter, OrderingFilter
from app.applicationlayer.ams.asset.table_filters import AMSAssetFilter
from app.applicationlayer.ams.asset import serializers
from app.applicationlayer.utils import(
    CustomPagination, status_message_response
)


class AMSAssetViewSet(viewsets.ModelViewSet):
    queryset = models.AMSAsset.objects
    serializer_class = serializers.AMSAssetSerializer
    pagination_class = CustomPagination
    lookup_field = 'code'
    filter_backends(
        DjangoFilterBackend, SearchFilter,
        OrderingFilter
    )
    ordering_fields = '__all__'
    search_filter = (
        'code',
        'name',
        'asset_type__name'
    )

    def list(self, request, *args, **kwargs):

        queryset = self.filter_queryset(self.get_queryset())

        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'List of Asset found!',
                serializer.data
            )

            return self.get_paginated_response(message)

        serializer = self.get_serializer(self.queryset, many=True)

        return Response(
            serializer.data,
            status=status.HTTP_200_OK
        )



