from app.entities.models import AMSAsset
from rest_framework import serializers


class AMSAssetSerializer(serializers.ModelSerializer):
    
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['asset_type'] = instance.asset_type.name
        return ret


    class Meta:
        model = AMSAsset
        fields = (
            'code'
            'name',
            'asset_type',
        )
        read_only_fields = (
            'created',
        )