from django.urls import path, include
from rest_framework import routers
from django.conf.urls import url

from app.applicationlayer.management.notification.views import NotificationsViewset
from app.applicationlayer.management.changerequest import views as crviews

router = routers.DefaultRouter()

router.register(r'notifications', NotificationsViewset)

router.register(r'template', crviews.ChangeRequestTemplatesViewset)
router.register(r'template-approvers', crviews.ChangeRequestTemplateApproversViewset)
router.register(r'template-attachments', crviews.ChangeRequestTemplateAttachmentsViewset)
router.register(r'template-stakeholders', crviews.ChangeRequestTemplateStakeHoldersViewset)
router.register(r'template-details', crviews.ChangeRequestTemplateDetailsViewset)

router.register(r'form', crviews.ChangeRequestFormsViewset)
router.register(r'form-approvers', crviews.ChangeRequestFormApproversViewset)
router.register(r'form-stakeholders', crviews.ChangeRequestFormStakeHoldersViewset)
router.register(r'form-attachments', crviews.ChangeRequestFormAttachmentsViewset)
router.register(r'form-details', crviews.ChangeRequestFormDetailsViewset)


urlpatterns = (
    path('', include(router.urls)),
    path('template-post/', crviews.ChangeRequestTemplatePost.as_view()),
    path('form-post/', crviews.ChangeRequestFormPost.as_view()),
)
