<<<<<<< HEAD
from django.shortcuts import render

from rest_framework import viewsets as meviewsets
from rest_framework.views import APIView
from app.applicationlayer.cms.template import serializers
from app.entities import models
from app.applicationlayer import paginators

from datetime import datetime
from datetime import timedelta

from rest_framework.response import Response
from rest_framework import status, views

from rest_framework.decorators import action
from django.http import Http404

from django.db.models import Q
import requests
from django.conf import settings
from rest_framework.exceptions import ValidationError
from django.db import transaction, IntegrityError, connection
from app.applicationlayer.utils import QuerySetHelper
from app.businesslayer.changerequest import change_request
from app.applicationlayer.cms.utils_cr import number_generator, crhistory_save
from django.shortcuts import get_object_or_404

from rest_framework.generics import GenericAPIView
from rest_framework.mixins import UpdateModelMixin
from django.forms.models import model_to_dict
from app.entities import enums


class ChangeRequestTemplatesViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateHeader.objects.all()
    lookup_field = 'template_no'
    serializer_class = serializers.ChangeRequestTemplatesSerializer
    pagination_class = paginators.SimplePageNumberPagination
    
    def list(self, request, *args, **kwargs):
        
        self.queryset = self.queryset.order_by('-created')
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplatesViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(
            template_no=str(self.kwargs.get('template_no'))
        ).first()

        serializer = self.get_serializer(instance)
        return Response(serializer.data)

    def destroy(self, request, *args, **kwargs):
        try:
            template_no = self.kwargs['template_no']
            instance = models.ChangeRequestTemplateHeader.objects.filter(
                Q(template_no=template_no) &
                Q(archived_at=None)
            ).update(archived_at=datetime.now())
            return Response({"message": "Deleted"}, status=status.HTTP_200_OK)
        except Exception as e:
            return Response(e,
                            status=status.HTTP_500_INTERNAL_SERVER_ERROR)

    @transaction.atomic
    def partial_update(self, request, *args, **kwargs):

        partial = kwargs.pop('partial', False)
        instance = self.get_object()

        template_no = kwargs['template_no']

        tmp_no_exists = models.ChangeRequestFormHeader.objects.filter(
            template_no=template_no)

        if not tmp_no_exists:
            serializer = self.get_serializer(instance, data=request.data, partial=partial)
            serializer.is_valid(raise_exception=True)

            old_instance = model_to_dict(instance)
            self.perform_update(serializer)
            new_instance = serializer.data

            # print(new_instance)

            crhistory_save(
                enums.LogEnum.UPDATE.value,
                enums.CREntitiesEnum.CR_TMP_HEADER.value,
                new_instance['template_no'],
                old_instance,
                new_instance
            )

            return Response(serializer.data)

        return Response(
            "Unable to edit due to existing transaction",
                status=status.HTTP_400_BAD_REQUEST
        )
    
    @action(
        methods=['PATCH'], detail=True,
        url_path='archived', url_name='archived'
    )
    def archived(self, request, *args, **kwargs):

        template_no = kwargs['template_no']

        tmp_no_exists = models.ChangeRequestFormHeader.objects.filter(
            template_no=template_no)

        if not tmp_no_exists:
            models.ChangeRequestTemplateDetails.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())

            models.ChangeRequestTemplateAttachments.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())
            
            models.ChangeRequestTemplateHeader.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())

            models.ChangeRequestTemplateApprovers.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())

            models.ChangeRequestTemplateStakeHolders.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())


            return Response(
                "Template successfully archived",
                    status=status.HTTP_200_OK
            )

        return Response(
            "Unable to archive due to existing transaction",
                status=status.HTTP_400_BAD_REQUEST
        )
        

class ChangeRequestTemplatePost(APIView):

    @transaction.atomic()
    def post(self, request):
        template_header = request.data

        try:
            data_list_approver = []
            data_list_stake = []
            data_list_attach = []
            data_list_detail = []

            template_header_data = {
                'requested_to_template_name': template_header['requested_to_template_name'],
                'requested_to_template_id': template_header['requested_to_template_id'],
                'requested_to_objective': template_header['requested_to_objective'],
                'requested_to_target_date': template_header['requested_to_target_date'],
                'requested_to_priority': template_header['requested_to_priority'],
                'description': template_header['description'],
                'created_by_department': template_header['created_by_department'],
                'created_by_user': template_header['created_by_user'],
                'requested_to_company': template_header['requested_to_company'],
                'requested_to_department': template_header['requested_to_department'],
                'requested_to_user': template_header['requested_to_user']
            }

            tmp_approvers = template_header['tmp_approvers']
            tmp_stakes = template_header['tmp_stakes']
            tmp_attachments = template_header['tmp_attachments']
            tmp_details = template_header['tmp_details']

            sp1 = transaction.savepoint()  # nothing will save to db

            serializer = serializers.ChangeRequestTemplatesSerializer(
                data=template_header_data)
            
            if serializer.is_valid(raise_exception=True):
                serializer.save()
            
            tmp_id = serializer.data['template_no']

            # create template approvers

            for tmp_approver in tmp_approvers:
                tmp_approver['template_no'] = tmp_id
                data_list_approver.append(tmp_approver)

            serializerApprover = serializers.ChangeRequestTemplateApproversSerializer(
                data=data_list_approver, many=True)
            
            if serializerApprover.is_valid(raise_exception=True):
                serializerApprover.save()

            # create template stakes

            for tmp_stake in tmp_stakes:
                tmp_stake['template_no'] = tmp_id
                data_list_stake.append(tmp_stake)

            serializerStake = serializers.ChangeRequestTemplateStakeHoldersSerializer(
                data=data_list_stake, many=True)

            if serializerStake.is_valid(raise_exception=True):
                serializerStake.save()
            
            # create template attachments

            for tmp_attachment in tmp_attachments:
                tmp_attachment['template_no'] = tmp_id
                data_list_attach.append(tmp_attachment)

            serializerAttach = serializers.ChangeRequestTemplateAttachmentsSerializer(
                data=data_list_attach, many=True)

            if serializerAttach.is_valid(raise_exception=True):
                serializerAttach.save()

            # create template details
            
            for tmp_detail in tmp_details:
                tmp_detail['template_no'] = tmp_id
                data_list_detail.append(tmp_detail)

            serializerDetail = serializers.ChangeRequestTemplateDetailsSerializer(
                data=data_list_detail, many=True)
            
            if serializerDetail.is_valid(raise_exception=True):
                serializerDetail.save()

            message = {
                'code': 201,
                'status': 'success',
                'message': 'Template Details successfully saved!',
                'results': serializer.data
            }

            return Response(message, status=status.HTTP_201_CREATED)

        except ValidationError as e:
            transaction.savepoint_rollback(sp1)
            message = {
                'code': 400,
                'status': 'failed',
                'message': str(e),
            }
            return Response(message, status=status.HTTP_400_BAD_REQUEST)

        except Exception as e:
            transaction.savepoint_rollback(sp1)
            message = {
                'code': 500,
                'status': 'failed',
                'message': 'Request was not able to process' + str(e),
            }
            return Response(message,
                            status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class ChangeRequestTemplateApproversViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateApprovers.objects.all()
    serializer_class = serializers.ChangeRequestTemplateApproversSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplateApproversViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestTemplateAttachmentsViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateAttachments.objects.all()
    serializer_class = serializers.ChangeRequestTemplateAttachmentsSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)

        return super(
            ChangeRequestTemplateAttachmentsViewset, self
        ).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)

class ChangeRequestTemplateStakeHoldersViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateStakeHolders.objects.all()
    serializer_class = serializers.ChangeRequestTemplateStakeHoldersSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplateStakeHoldersViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestTemplateDetailsViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateDetails.objects.all()
    serializer_class = serializers.ChangeRequestTemplateDetailsSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplateDetailsViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
=======
from django.shortcuts import render

from rest_framework import viewsets as meviewsets
from rest_framework.views import APIView
from app.applicationlayer.cms.template import serializers
from app.entities import models
from app.applicationlayer import paginators

from datetime import datetime
from datetime import timedelta

from rest_framework.response import Response
from rest_framework import status, views

from rest_framework.decorators import action
from django.http import Http404

from django.db.models import Q
import requests
from django.conf import settings
from rest_framework.exceptions import ValidationError
from django.db import transaction, IntegrityError, connection
from app.applicationlayer.utils import QuerySetHelper
from app.businesslayer.changerequest import change_request
from app.applicationlayer.cms.utils_cr import number_generator, crhistory_save
from django.shortcuts import get_object_or_404

from rest_framework.generics import GenericAPIView
from rest_framework.mixins import UpdateModelMixin
from django.forms.models import model_to_dict
from app.entities import enums


class ChangeRequestTemplatesViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateHeader.objects.all()
    lookup_field = 'template_no'
    serializer_class = serializers.ChangeRequestTemplatesSerializer
    pagination_class = paginators.SimplePageNumberPagination
    
    def list(self, request, *args, **kwargs):
        
        self.queryset = self.queryset.order_by('-created')
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplatesViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(
            template_no=str(self.kwargs.get('template_no'))
        ).first()

        serializer = self.get_serializer(instance)
        return Response(serializer.data)

    def destroy(self, request, *args, **kwargs):
        try:
            template_no = self.kwargs['template_no']
            instance = models.ChangeRequestTemplateHeader.objects.filter(
                Q(template_no=template_no) &
                Q(archived_at=None)
            ).update(archived_at=datetime.now())
            return Response({"message": "Deleted"}, status=status.HTTP_200_OK)
        except Exception as e:
            return Response(e,
                            status=status.HTTP_500_INTERNAL_SERVER_ERROR)

    @transaction.atomic
    def partial_update(self, request, *args, **kwargs):

        partial = kwargs.pop('partial', False)
        instance = self.get_object()

        template_no = kwargs['template_no']

        tmp_no_exists = models.ChangeRequestFormHeader.objects.filter(
            template_no=template_no)

        if not tmp_no_exists:
            serializer = self.get_serializer(instance, data=request.data, partial=partial)
            serializer.is_valid(raise_exception=True)

            old_instance = model_to_dict(instance)
            self.perform_update(serializer)
            new_instance = serializer.data

            # print(new_instance)

            crhistory_save(
                enums.LogEnum.UPDATE.value,
                enums.CREntitiesEnum.CR_TMP_HEADER.value,
                new_instance['template_no'],
                old_instance,
                new_instance
            )

            return Response(serializer.data)

        return Response(
            "Unable to edit due to existing transaction",
                status=status.HTTP_400_BAD_REQUEST
        )
    
    @action(
        methods=['PATCH'], detail=True,
        url_path='archived', url_name='archived'
    )
    def archived(self, request, *args, **kwargs):

        template_no = kwargs['template_no']

        tmp_no_exists = models.ChangeRequestFormHeader.objects.filter(
            template_no=template_no)

        if not tmp_no_exists:
            models.ChangeRequestTemplateDetails.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())

            models.ChangeRequestTemplateAttachments.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())
            
            models.ChangeRequestTemplateHeader.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())

            models.ChangeRequestTemplateApprovers.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())

            models.ChangeRequestTemplateStakeHolders.objects.filter(
                template_no=template_no
            ).update(archived_at=datetime.now())


            return Response(
                "Template successfully archived",
                    status=status.HTTP_200_OK
            )

        return Response(
            "Unable to archive due to existing transaction",
                status=status.HTTP_400_BAD_REQUEST
        )
        

class ChangeRequestTemplatePost(APIView):

    @transaction.atomic()
    def post(self, request):
        template_header = request.data

        try:
            data_list_approver = []
            data_list_stake = []
            data_list_attach = []
            data_list_detail = []

            template_header_data = {
                'requested_to_template_name': template_header['requested_to_template_name'],
                'requested_to_template_id': template_header['requested_to_template_id'],
                'requested_to_objective': template_header['requested_to_objective'],
                'requested_to_target_date': template_header['requested_to_target_date'],
                'requested_to_priority': template_header['requested_to_priority'],
                'description': template_header['description'],
                'created_by_department': template_header['created_by_department'],
                'created_by_user': template_header['created_by_user'],
                'requested_to_company': template_header['requested_to_company'],
                'requested_to_department': template_header['requested_to_department'],
                'requested_to_user': template_header['requested_to_user']
            }

            tmp_approvers = template_header['tmp_approvers']
            tmp_stakes = template_header['tmp_stakes']
            tmp_attachments = template_header['tmp_attachments']
            tmp_details = template_header['tmp_details']

            sp1 = transaction.savepoint()  # nothing will save to db

            serializer = serializers.ChangeRequestTemplatesSerializer(
                data=template_header_data)
            
            if serializer.is_valid(raise_exception=True):
                serializer.save()
            
            tmp_id = serializer.data['template_no']

            # create template approvers

            for tmp_approver in tmp_approvers:
                tmp_approver['template_no'] = tmp_id
                data_list_approver.append(tmp_approver)

            serializerApprover = serializers.ChangeRequestTemplateApproversSerializer(
                data=data_list_approver, many=True)
            
            if serializerApprover.is_valid(raise_exception=True):
                serializerApprover.save()

            # create template stakes

            for tmp_stake in tmp_stakes:
                tmp_stake['template_no'] = tmp_id
                data_list_stake.append(tmp_stake)

            serializerStake = serializers.ChangeRequestTemplateStakeHoldersSerializer(
                data=data_list_stake, many=True)

            if serializerStake.is_valid(raise_exception=True):
                serializerStake.save()
            
            # create template attachments

            for tmp_attachment in tmp_attachments:
                tmp_attachment['template_no'] = tmp_id
                data_list_attach.append(tmp_attachment)

            serializerAttach = serializers.ChangeRequestTemplateAttachmentsSerializer(
                data=data_list_attach, many=True)

            if serializerAttach.is_valid(raise_exception=True):
                serializerAttach.save()

            # create template details
            
            for tmp_detail in tmp_details:
                tmp_detail['template_no'] = tmp_id
                data_list_detail.append(tmp_detail)

            serializerDetail = serializers.ChangeRequestTemplateDetailsSerializer(
                data=data_list_detail, many=True)
            
            if serializerDetail.is_valid(raise_exception=True):
                serializerDetail.save()

            message = {
                'code': 201,
                'status': 'success',
                'message': 'Template Details successfully saved!',
                'results': serializer.data
            }

            return Response(message, status=status.HTTP_201_CREATED)

        except ValidationError as e:
            transaction.savepoint_rollback(sp1)
            message = {
                'code': 400,
                'status': 'failed',
                'message': str(e),
            }
            return Response(message, status=status.HTTP_400_BAD_REQUEST)

        except Exception as e:
            transaction.savepoint_rollback(sp1)
            message = {
                'code': 500,
                'status': 'failed',
                'message': 'Request was not able to process' + str(e),
            }
            return Response(message,
                            status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class ChangeRequestTemplateApproversViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateApprovers.objects.all()
    serializer_class = serializers.ChangeRequestTemplateApproversSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplateApproversViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestTemplateAttachmentsViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateAttachments.objects.all()
    serializer_class = serializers.ChangeRequestTemplateAttachmentsSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)

        return super(
            ChangeRequestTemplateAttachmentsViewset, self
        ).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)

class ChangeRequestTemplateStakeHoldersViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateStakeHolders.objects.all()
    serializer_class = serializers.ChangeRequestTemplateStakeHoldersSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplateStakeHoldersViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestTemplateDetailsViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateDetails.objects.all()
    serializer_class = serializers.ChangeRequestTemplateDetailsSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = "code"

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestTemplateDetailsViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
>>>>>>> d48679c96ca8ba780357ca8f9fa91b68cfa3778b
        return Response(serializer.data)