from rest_framework import serializers
from app.entities.models import Module, Application
# from app.applicationlayer.management.application import ApplicationSerializer


class ModuleSerializer(serializers.ModelSerializer):
    def to_representation(self, instance):
        application_name = Application.objects.filter(
            id=instance.application.id
        ).values().first()
        ret = super().to_representation(instance)
        ret['application'] = application_name
        # ret['application'] = application_name

        return ret

    class Meta:
        model = Module
        fields = '__all__'
        read_only_fields = (
            'created', 'createdby', 'modified', 'modifiedby', 'code',
        )
