# Generated by Django 2.2 on 2019-12-10 11:34

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('user_type', models.CharField(choices=[('SU', 'SU'), ('OUA', 'OUA'), ('CUA', 'CUA'), ('DUA', 'DUA'), ('USR', 'USR')], default='USR', max_length=100)),
                ('code', models.CharField(default='acct', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('username', models.CharField(max_length=255, unique=True)),
                ('password', models.CharField(blank=True, max_length=255, null=True)),
                ('contact_no', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(max_length=255)),
            ],
            options={
                'db_table': 'auth_user',
            },
        ),
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('excel_code', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'applications',
            },
        ),
        migrations.CreateModel(
            name='AssetGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('asset_group', models.CharField(max_length=255, unique=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'db_table': 'asset_groups',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.FileField(max_length=255, null=True, upload_to='file_attachments/')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'db_table': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestFormApprovers',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.IntegerField()),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('remarks', models.CharField(blank=True, max_length=255, null=True)),
                ('action', models.CharField(blank=True, max_length=50, null=True)),
                ('action_date', models.DateTimeField(blank=True, null=True)),
                ('date_sent', models.DateTimeField(blank=True, null=True)),
                ('is_action', models.BooleanField(default=False)),
            ],
            options={
                'db_table': 'change_request_form_approvers',
                'ordering': ['level'],
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestFormHeader',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('requested_to_template_name', models.CharField(max_length=255)),
                ('requested_to_objective', models.CharField(blank=True, max_length=255, null=True)),
                ('requested_to_priority', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=True)),
                ('form_code', models.CharField(max_length=255, unique=True)),
                ('cancel_date', models.DateTimeField(blank=True, null=True)),
                ('status', models.CharField(max_length=50)),
                ('company_desc', models.CharField(blank=True, max_length=255, null=True)),
                ('department_desc', models.CharField(blank=True, max_length=255, null=True)),
                ('requested_desc', models.CharField(blank=True, max_length=255, null=True)),
                ('requested_to_template_id', models.CharField(max_length=255)),
                ('requested_to_target_date', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'db_table': 'change_request_form_headers',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('batch_no', models.CharField(blank=True, max_length=255, null=True)),
                ('main_action', models.CharField(blank=True, max_length=255, null=True)),
                ('action', models.CharField(max_length=50)),
                ('entity', models.CharField(max_length=50)),
                ('form_code', models.CharField(blank=True, max_length=255, null=True)),
                ('fromValue', models.TextField(blank=True, null=True)),
                ('toValue', models.TextField(blank=True, null=True)),
                ('requested_to_template_id', models.CharField(blank=True, max_length=255, null=True)),
                ('template_no', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'db_table': 'change_request_history',
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestTemplateHeader',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('requested_to_template_name', models.CharField(max_length=255)),
                ('requested_to_objective', models.CharField(blank=True, max_length=255, null=True)),
                ('requested_to_priority', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=True)),
                ('template_no', models.CharField(max_length=255, unique=True)),
                ('requested_to_template_id', models.CharField(max_length=255, unique=True)),
                ('requested_to_target_date', models.IntegerField()),
            ],
            options={
                'db_table': 'change_request_template_headers',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(default='com', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('contact_details', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'companies',
            },
        ),
        migrations.CreateModel(
            name='Delegation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
            ],
            options={
                'db_table': 'delegations',
            },
        ),
        migrations.CreateModel(
            name='EmailLogs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('template', models.CharField(max_length=255)),
                ('recipients', models.CharField(max_length=255)),
                ('content', models.TextField()),
                ('is_sent', models.BooleanField(default=True)),
            ],
            options={
                'db_table': 'email_logs',
            },
        ),
        migrations.CreateModel(
            name='EntityLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('action', models.CharField(choices=[('Add', 'Add'), ('Update', 'Update'), ('DELETED', 'DELETED')], default='Add', max_length=50)),
                ('entity', models.CharField(choices=[('USER', 'USER'), ('APPLICATION', 'APPLICATION'), ('COMPANY', 'COMPANY'), ('DEPARTMENT', 'DEPARTMENT'), ('MODULE', 'MODULE'), ('DELEGATION', 'DELEGATION'), ('ChangeRequestTemplateHeader', 'ChangeRequestTemplateHeader'), ('ChangeRequestTemplateApprovers', 'ChangeRequestTemplateApprovers'), ('ChangeRequestTemplateStakeHolders', 'ChangeRequestTemplateStakeHolders'), ('ChangeRequestTemplateAttachments', 'ChangeRequestTemplateAttachments'), ('ChangeRequestTemplateDetails', 'ChangeRequestTemplateDetails'), ('ChangeRequestFormHeader', 'ChangeRequestFormHeader'), ('ChangeRequestFormApprovers', 'ChangeRequestFormApprovers'), ('ChangeRequestFormStakeHolders', 'ChangeRequestFormStakeHolders'), ('ChangeRequestFormAttachments', 'ChangeRequestFormAttachments'), ('ChangeRequestFormDetails', 'ChangeRequestFormDetails')], default='Add', max_length=50)),
                ('row_id', models.IntegerField()),
                ('fromValue', models.TextField(blank=True, null=True)),
                ('toValue', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'entity_logs',
            },
        ),
        migrations.CreateModel(
            name='ExtractTransformLoad',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('file_name', models.CharField(max_length=255)),
                ('model_type', models.CharField(choices=[('APP', 'APP'), ('MODULE', 'MODULE'), ('COMPANY', 'COMPANY'), ('DEPARTMENT', 'DEPARTMENT'), ('USER', 'USER'), ('DELEGATION', 'DELEGATION'), ('NOTIF', 'NOTIF'), ('TMP', 'TMP'), ('TMPAPR', 'TMPAPR'), ('TMPSTK', 'TMPSTK'), ('TMPATCH', 'TMPATCH'), ('TMPDETAIL', 'TMPDETAIL'), ('FRM', 'FRM'), ('FRMAPR', 'FRMAPR'), ('FRMSTK', 'FRMSTK'), ('FRMATCH', 'FRMATCH'), ('FRMDETAIL', 'FRMDETAIL'), ('ETL', 'ETL'), ('AMSGRP', 'AMSGRP')], default='USER', max_length=100)),
                ('code', models.CharField(blank=True, max_length=255, null=True, unique=True)),
            ],
            options={
                'db_table': 'extract_transform_load',
            },
        ),
        migrations.CreateModel(
            name='MasterAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.FileField(blank=True, null=True, upload_to='uploads/')),
                ('attch_ref', models.TextField()),
            ],
            options={
                'db_table': 'master_attachments',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('form_code', models.CharField(blank=True, max_length=255, null=True)),
                ('app', models.CharField(blank=True, max_length=255, null=True)),
                ('notif_type', models.CharField(choices=[('REMINDER', 'REMINDER'), ('ACTIVITY', 'ACTIVITY'), ('TASK', 'TASK')], default='TASK', max_length=20)),
                ('account_no', models.CharField(blank=True, max_length=255, null=True)),
                ('message', models.CharField(blank=True, max_length=255, null=True)),
                ('is_read', models.BooleanField(default=False, null=True)),
                ('sender_account_no', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'notifications',
            },
        ),
        migrations.CreateModel(
            name='PasswordReset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=255)),
                ('token', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField()),
                ('timeout_at', models.DateTimeField()),
                ('is_active', models.BooleanField(default=True)),
                ('code', models.CharField(max_length=50)),
            ],
            options={
                'db_table': 'password_resets',
            },
        ),
        migrations.CreateModel(
            name='Permission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255, null=True)),
                ('code', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('description', models.CharField(max_length=255, null=True)),
            ],
            options={
                'db_table': 'permissions',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('code', models.CharField(default='role', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'roles',
            },
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('ref', models.CharField(max_length=10)),
                ('code', models.CharField(max_length=10, unique=True)),
                ('name', models.CharField(max_length=10, unique=True)),
                ('description', models.CharField(max_length=100, null=True)),
            ],
            options={
                'db_table': 'status_set',
            },
        ),
        migrations.CreateModel(
            name='UserImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('image', models.ImageField(max_length=255, null=True, upload_to='user_images/')),
                ('is_primary', models.BooleanField(default=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_images', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'auth_user_images',
            },
        ),
        migrations.CreateModel(
            name='UserHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('username', models.CharField(max_length=255)),
                ('email', models.EmailField(max_length=255)),
                ('password', models.CharField(max_length=255)),
                ('sent', models.BooleanField(default=False)),
                ('deleted', models.BooleanField(default=False)),
                ('file_name', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='extract_transform_load', to='entities.ExtractTransformLoad', to_field='code')),
            ],
            options={
                'db_table': 'extract_transform_load_user_history',
            },
        ),
        migrations.CreateModel(
            name='RolePermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('permission', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='role_permissions', to='entities.Permission')),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='role_permissions', to='entities.Role')),
            ],
            options={
                'db_table': 'role_permissions',
            },
        ),
        migrations.CreateModel(
            name='ReminderTrigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('auto_cancel_date', models.DateTimeField(blank=True, null=True)),
                ('date_submitted_last_approver', models.DateTimeField(blank=True, null=True)),
                ('date_from', models.DateTimeField(blank=True, null=True)),
                ('date_to', models.DateTimeField(blank=True, null=True)),
                ('date_to_send', models.DateTimeField(blank=True, null=True)),
                ('is_sent', models.BooleanField(default=False)),
                ('form_code', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='entities.ChangeRequestFormHeader', to_field='form_code')),
                ('frm_approver', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.ChangeRequestFormApprovers', to_field='code')),
            ],
            options={
                'db_table': 'trigger_reminder',
            },
        ),
        migrations.CreateModel(
            name='OverdueTrigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('overdue_date', models.DateTimeField(blank=True, null=True)),
                ('is_sent', models.BooleanField(default=False)),
                ('form_code', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.ChangeRequestFormHeader', to_field='form_code')),
            ],
            options={
                'db_table': 'trigger_overdue',
            },
        ),
        migrations.CreateModel(
            name='Module',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(default='mod', max_length=255, unique=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('sort_id', models.IntegerField()),
                ('component', models.CharField(blank=True, max_length=255, null=True)),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='modules', to='entities.Application', to_field='code')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='module_parent', to='entities.Module')),
            ],
            options={
                'db_table': 'modules',
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('createdby', models.CharField(max_length=255)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('modifiedby', models.CharField(max_length=255)),
                ('code', models.CharField(default='dept', max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='companies', to='entities.Company', to_field='code')),
                ('delegation', models.ManyToManyField(related_name='departments', to='entities.Delegation')),
            ],
            options={
                'db_table': 'departments',
                'unique_together': {('company', 'name')},
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestTemplateStakeHolders',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('delegation', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('template_no', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='tmp_stakes', to='entities.ChangeRequestTemplateHeader', to_field='template_no')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'change_request_template_stakeholders',
            },
        ),
        migrations.AddField(
            model_name='changerequesttemplateheader',
            name='created_by_department',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='created_by_department', to='entities.Department', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequesttemplateheader',
            name='created_by_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='created_by_user', to=settings.AUTH_USER_MODEL, to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequesttemplateheader',
            name='requested_to_company',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.Company', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequesttemplateheader',
            name='requested_to_department',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.Department', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequesttemplateheader',
            name='requested_to_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code'),
        ),
        migrations.CreateModel(
            name='ChangeRequestTemplateDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field_idx', models.TextField(blank=True, null=True)),
                ('field_ref', models.TextField(blank=True, null=True)),
                ('field_val', models.TextField(blank=True, null=True)),
                ('field_props', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('template_no', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='tmp_details', to='entities.ChangeRequestTemplateHeader', to_field='template_no')),
            ],
            options={
                'db_table': 'change_request_template_details',
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestTemplateAttachments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attachment_type', models.CharField(max_length=255)),
                ('attachment_name', models.CharField(max_length=255)),
                ('file_name', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('file_upload', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='template_attachments', to='entities.MasterAttachment')),
                ('template_no', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='tmp_attachments', to='entities.ChangeRequestTemplateHeader', to_field='template_no')),
                ('uploaded_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'change_request_template_attachments',
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestTemplateApprovers',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.IntegerField()),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('is_default', models.BooleanField(default=False)),
                ('company', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='entities.Company', to_field='code')),
                ('delegation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='entities.Delegation', to_field='code')),
                ('department', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='entities.Department', to_field='code')),
                ('template_no', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='tmp_approvers', to='entities.ChangeRequestTemplateHeader', to_field='template_no')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'change_request_template_approvers',
                'ordering': ['level'],
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestFormStakeHolders',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('delegation', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('date_added', models.DateTimeField(blank=True, null=True)),
                ('form_code', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='frm_stakes', to='entities.ChangeRequestFormHeader', to_field='form_code')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'change_request_form_stakeholders',
            },
        ),
        migrations.AddField(
            model_name='changerequestformheader',
            name='requested_by_department',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='requested_by_department', to='entities.Department', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequestformheader',
            name='requested_by_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='requested_by_user', to=settings.AUTH_USER_MODEL, to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequestformheader',
            name='requested_to_company',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.Company', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequestformheader',
            name='requested_to_department',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.Department', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequestformheader',
            name='requested_to_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequestformheader',
            name='template_no',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.ChangeRequestTemplateHeader', to_field='template_no'),
        ),
        migrations.CreateModel(
            name='ChangeRequestFormDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field_idx', models.TextField(blank=True, null=True)),
                ('field_ref', models.TextField(blank=True, null=True)),
                ('field_val', models.TextField(blank=True, null=True)),
                ('field_props', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('form_code', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='frm_details', to='entities.ChangeRequestFormHeader', to_field='form_code')),
            ],
            options={
                'db_table': 'change_request_form_details',
            },
        ),
        migrations.CreateModel(
            name='ChangeRequestFormAttachments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attachment_type', models.CharField(max_length=255)),
                ('attachment_name', models.CharField(max_length=255)),
                ('file_name', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('file_upload', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='form_attachments', to='entities.MasterAttachment')),
                ('form_code', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='frm_attachments', to='entities.ChangeRequestFormHeader', to_field='form_code')),
                ('uploaded_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'change_request_form_attachments',
            },
        ),
        migrations.AddField(
            model_name='changerequestformapprovers',
            name='delegation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='entities.Delegation', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequestformapprovers',
            name='form_code',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='frm_approvers', to='entities.ChangeRequestFormHeader', to_field='form_code'),
        ),
        migrations.AddField(
            model_name='changerequestformapprovers',
            name='tmp_approver',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='entities.ChangeRequestTemplateApprovers', to_field='code'),
        ),
        migrations.AddField(
            model_name='changerequestformapprovers',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, to_field='code'),
        ),
        migrations.CreateModel(
            name='CancelTrigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('auto_cancel_date', models.DateTimeField(blank=True, null=True)),
                ('is_sent', models.BooleanField(default=False)),
                ('date_submitted_last_approver', models.DateTimeField(blank=True, null=True)),
                ('cancel_type', models.CharField(blank=True, max_length=255, null=True)),
                ('form_code', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='entities.ChangeRequestFormHeader', to_field='form_code')),
                ('frm_approver', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='entities.ChangeRequestFormApprovers', to_field='code')),
            ],
            options={
                'db_table': 'trigger_cancel',
            },
        ),
        migrations.CreateModel(
            name='AuthToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ref', models.CharField(max_length=255)),
                ('token', models.TextField()),
                ('passcode', models.CharField(max_length=255)),
                ('is_active', models.BooleanField(default=False)),
                ('created', models.DateTimeField(blank=True, null=True)),
                ('timeout_at', models.DateTimeField(blank=True, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='auth_access_token', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'auth_access_token',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='application',
            field=models.ManyToManyField(to='entities.Application'),
        ),
        migrations.AddField(
            model_name='user',
            name='default_app',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='default_app', to='entities.Application', to_field='code'),
        ),
        migrations.AddField(
            model_name='user',
            name='department',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='department_users', to='entities.Department', to_field='code'),
        ),
        migrations.AddField(
            model_name='user',
            name='doa',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='doa_users', to=settings.AUTH_USER_MODEL, to_field='code'),
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
        migrations.CreateModel(
            name='AllowedCompany',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_change_request', models.BooleanField(default=True)),
                ('create_change_request_template', models.BooleanField(default=True)),
                ('view_all_change_request', models.BooleanField(default=True)),
                ('approve_cr', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('company_pivot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='allowed_company_company_pivot', to='entities.Company', to_field='code')),
                ('group_pivots', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='allowed_company_group_pivots', to='entities.Department', to_field='code')),
                ('id_number', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='allowed_company_id_number', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'allowed_company',
                'unique_together': {('company_pivot', 'group_pivots', 'id_number')},
            },
        ),
    ]