from rest_framework import serializers
from app.entities.models import AMSPrivilege
from app.applicationlayer.utils import model_to_dict


class AMSPrivilegeSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['id_number'] = model_to_dict(instance.id_number)
        ret['department'] = model_to_dict(instance.department)
        ret['company'] = model_to_dict(instance.department.company)
        ret['ams_user_type'] = instance.ams_user_type
        return ret
    
    class Meta:
        model = AMSPrivilege
        fields = '__all__'

