from rest_framework import serializers
from app.entities.models import AllowedCompany
from django.forms.models import model_to_dict

class AllowedCompanySerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['department'] = model_to_dict(instance.group_pivots)
        ret['company'] = model_to_dict(instance.company_pivot)
        return ret

    class Meta:
        model = AllowedCompany
        fields = '__all__'

