from rest_framework import status
from rest_framework.test import APITestCase
from rest_framework.test import force_authenticate
from rest_framework.test import APIClient
from app.entities.models import User

# from api.models import ChatRoom


class ChatRoomTest(APITestCase):


    fixtures = ['red-dump2.json']


    def test_login2(self):
        self.url = '/api/v1/auth/login/'
        self.body = {
            "username": 'superuser',
            'password': 'password123'
        }

        request = self.client.post(self.url, self.body, format='multipart')

        self.assertEqual(request.status_code, status.HTTP_200_OK)

    # def test_login(self):
    #     self.url = '/api/v1/auth/login/'
    #     self.body = {
    #         "username": 'superuse2r',
    #         'password': 'password123'
    #     }

    #     request = self.client.post(self.url, self.body, format='multipart')

    #     self.assertEqual(request.status_code, status.HTTP_400_BAD_REQUEST)

    def test_companies(self):
        self.url = '/api/v1/master/companies/'
        self.client = APIClient()
        self.client.credentials(HTTP_AUTHORIZATION='Bearer 8b6d17d859bef3c660d516d9dde982ba73e74de0')
        request = self.client.get(self.url, format='json')
        self.assertEqual(request.status_code, status.HTTP_200_OK)


    # def test_companies_slug(self):
    #     self.url = '/api/v1/master/companies/1/'
    #     self.client = APIClient()
    #     self.client.credentials(HTTP_AUTHORIZATION='Bearer 8b6d17d859bef3c660d516d9dde982ba73e74de0')
    #     request = self.client.get(self.url, format='json')
    #     self.assertEqual(request.status_code, status.HTTP_200_OK)


    def test_companies_slug_error(self):
        self.url = '/api/v1/master/companies/100/'
        self.client = APIClient()
        self.client.credentials(HTTP_AUTHORIZATION='Bearer 8b6d17d859bef3c660d516d9dde982ba73e74de0')
        request = self.client.get(self.url, format='json')
        self.assertEqual(request.status_code, status.HTTP_400_BAD_REQUEST)


    def test_companies_slug_correct(self):
        self.url = '/api/v1/master/companies/1/'
        self.client = APIClient()
        self.client.credentials(HTTP_AUTHORIZATION='Bearer 8b6d17d859bef3c660d516d9dde982ba73e74de0')
        request = self.client.get(self.url, format='json')
        self.assertEqual(request.status_code, status.HTTP_200_OK)

