from rest_framework import serializers
from app.entities.models import ExtractTransformLoad, UserHistory


class ExtractTransformLoadSerializer(serializers.ModelSerializer):
    class Meta:
        model = ExtractTransformLoad
        fields = '__all__'
        read_only_fields = (
            'created', 'createdby', 'modified', 'modifiedby', 'code',
        )


class UserHistorySerializer(serializers.ModelSerializer):
    class Meta:
        model = UserHistory
        fields = '__all__'
        read_only_fields = (
            'created', 'createdby', 'modified', 'code'
        )
