from rest_framework import serializers
from app.entities.models import Department, Company


class DepartmentSerializer(serializers.ModelSerializer):
    def to_representation(self, instance):
        company_name = Company.objects.filter(
            id=instance.company.id
        ).values().first()
        ret = super().to_representation(instance)
        ret['company'] = company_name
        # ret['application'] = application_name

        return ret
        
    class Meta:
        model = Department
        fields = '__all__'
        read_only_fields = (
            'created', 'createdby', 'modified', 'modifiedby', 'code',
        )
