from app.entities import models
from rest_framework import serializers
from django.db.models import Q


class headers(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['deparment'] = instance.department.name
        ret['company'] = instance.department.company.name

        return ret

    class Meta:
        model = models.User
        fields = (
            'code',
            'name',
            'email',
            'contact_no'
        )
