from app.helper.decorators import rms
from app.entities.models import Company
from rest_framework import viewsets, status
from rest_framework.response import Response
from django_filters import rest_framework as filters
from django_filters.rest_framework import DjangoFilterBackend
from app.applicationlayer.management.company import serializer
from rest_framework.filters import SearchFilter, OrderingFilter
from app.applicationlayer.master.company.serializer import AdminCompanySerializer
from app.applicationlayer.utils import CustomPagination, status_message_response
from app.applicationlayer.management.company.table_filters import CompanyFilterSet


class AdminCompanyViewSet(viewsets.ModelViewSet):
    queryset = Company.objects.all()
    serializer_class = AdminCompanySerializer
    pagination_class = CustomPagination
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = CompanyFilterSet
    ordering_fields = '__all__'
    search_fields = ('name',)
    http_method_names = ['get']

    @rms.company_list
    def list(self, request, *args, **kwargs):

        queryset = self.filter_queryset(self.get_queryset())
        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'list of Company found',
                serializer.data
            )
            return self.get_paginated_response(message)

        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)
