from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class AMSReportSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['created_by'] = instance.created_by.name
        ret['report_type'] = instance.report_type.name
        ret['unique_identifier'] = instance.asset_stock.unique_identifier
        ret['asset'] = instance.asset_stock.asset.name
        ret['asset_type'] = instance.asset_stock.asset.asset_type.name
        del ret['asset_stock']
        
        return ret

    class Meta:
        model = models.AMSReport
        fields = '__all__'