from rest_framework.views import APIView
from app.applicationlayer.utils import (CustomPagination,
                                        status_message_response)
from app.applicationlayer.management.account.serializer import ChangeRequestList
from app.entities import models
from rest_framework.response import Response
from django.db.models import Q
from rest_framework import status


class UserListTemplate(APIView):

    pagination_class = CustomPagination

    def get(self, request, *args, **kwargs):
        # try:
            serializer = ChangeRequestList
            dept = self.request.query_params['department_code']
            user_codes = models.User.objects.filter(
                department=dept
            ).values('code').exclude(id=1)
            
            verified_users = models.AllowedCompany.objects.filter(
                Q(id_number__in=user_codes) &
                Q(create_change_request_template=True)
            ).values('id_number').exclude(id=request.user.id)

            user_list = models.User.objects.filter(
                code__in=verified_users
            )



            page = self.paginate_queryset(user_list)

            if page is not None:

                serializer = ChangeRequestList(page, many=True)

                message = status_message_response(
                    200,
                    'success',
                    'list of User found',
                    serializer.data
                )
            return self.get_paginated_response(message)

        # except Exception as e:
        #     return Response(
        #         {"message": "this endpoint expect a query params department_id"},
        #         status=status.HTTP_400_BAD_REQUEST
        #     )

    @property
    def paginator(self):
        """
        The paginator instance associated with the view, or `None`.
        """
        if not hasattr(self, '_paginator'):
            if self.pagination_class is None:
                self._paginator = None
            else:
                self._paginator = self.pagination_class()
        return self._paginator

    def paginate_queryset(self, queryset):
        """
        Return a single page of results, or `None` if pagination is disabled.
        """
        if self.paginator is None:
            return None
        return self.paginator.paginate_queryset(queryset, self.request, view=self)

    def get_paginated_response(self, data):
        """
        Return a paginated style `Response` object for the given output data.
        """
        assert self.paginator is not None
        return self.paginator.get_paginated_response(data)