from rest_framework import serializers
from app.applicationlayer import serializers as app_serializers
from app.entities import models
from django.db.models import Q


# Used for Create and Update
class UserManagementSerializer(serializers.ModelSerializer):
    image = serializers.SerializerMethodField()

    class Meta:
        model = models.User
        exclude = ['password']

    def get_image(self, user):
        request = self.context.get('request')

        primayPic = user.user_images.filter(is_primary=True).first()
        if primayPic:
            print(primayPic.image.url)
            return request.build_absolute_uri(primayPic.image.url)
        else:
            return request.build_absolute_uri('/media/no-user.png')


# Used for Retrieve and List
class UserManagementRoleSerializer(serializers.ModelSerializer):
    permissions = serializers.SlugRelatedField(many=True,
                                               read_only=True,
                                               slug_field='code')

    class Meta:
        model = models.Role
        fields = '__all__'
        read_only_fields = ['createdby', 'modifiedby', 'created', 'modified']


# Used for Retrieve and List
class UserManagementRetreiveSerializer(serializers.ModelSerializer):
    image = serializers.SerializerMethodField()
    applications = serializers.SerializerMethodField()
    department = serializers.SerializerMethodField()
    company = serializers.SerializerMethodField()

    class Meta:
        model = models.User
        fields = (
            'id',
            'code', 'name',
            'username', 'contact_no',
            'image', 'company',
            'department', 'applications',
            'email', 'default_app',
            'user_type', 'is_active',
            'doa',
            
        )
        # exclude = ['password', 'application', 'groups', 'user_permissions']


    def get_department(self, user):
        data = {
            "id": user.department.id,
            "name": user.department.name
        }
        return data

    def get_company(self, user):
        data = {
            "id": user.department.company.id,
            "name": user.department.company.name
        }
        return data

    def get_image(self, user):
        request = self.context.get('request')

        primayPic = user.user_images.filter(is_primary=True).first()
        if primayPic:
            print(primayPic.image.url)
            return request.build_absolute_uri(primayPic.image.url)
        else:
            return request.build_absolute_uri('/media/no-user.png')

    def get_applications(self, user):
        app = user.application.all()
        list_app = []
        for data in app:
            if user.user_type.upper() == 'USR' and data.id == 1:
                pass
            else:
                remove = ['Modules', 'Companies', 'Department']

                if user.user_type == 'SU':
                    mod = data.modules.all().values('name')
                else:
                    mod = data.modules.exclude(name__in=remove).values(
                        "id", 'name', 'parent'
                    )
                    # mod = mod.exclude(~Q(parent=0))
                    mod = mod.order_by('parent', 'sort_id')
                    # list_mod = []
                    # for body in mod:
                    #     parent_id = body['id']
                    #     child_module = models.Module.objects.filter(
                    #         parent=parent_id
                    #     )
                    #     if child_module:
                    #         body['sub_modules'] = child_module.values(
                    #             "id", 'name', 'parent'
                    #         )
                    #     list_mod.append(body)

                app_body = {}
                app_body['app_code'] = data.code
                app_body['name'] = data.name
                app_body['modules'] = mod
                list_app.append(app_body)
        return list_app


class ChangePasswordSerializer(serializers.Serializer):
    old_password = serializers.CharField(max_length=100, required=True)
    new_password = serializers.CharField(max_length=100, required=True)
    new_password_confirm = serializers.CharField(max_length=100, required=True)

    class Meta:
        fields = '__all__'


# class UserSpecialPermissionSerializer(serializers.Serializer):
#     special_permissions = app_serializers.PermissionSerializer(required=True,
#                                                                many=True)

#     class Meta:
#         fields = '__all__'
