from app.entities import models
from app.applicationlayer import paginators
from datetime import datetime
from rest_framework.response import Response
from rest_framework import status, views

from django.db.models import Q
import requests
from django.conf import settings
from datetime import timedelta
from app.helper.email_service import sender
from app.applicationlayer.utils import main_threading
from rest_framework.permissions import AllowAny

CR_FRONT_LINK = settings.CR_FRONT_LINK

class ReminderTriggerAPIView(views.APIView):

    permission_classes = (AllowAny,)
    
    def get(self, request):
        date_now = datetime.now()
        next_day = date_now + timedelta(days=1)
        today_mail = models.ReminderTrigger.objects.filter(
            Q(date_from__gte=date_now.strftime('%Y-%m-%d 00:00:00.000')) &
            Q(date_to__lte=date_now.strftime('%Y-%m-%d 00:00:00.000')) &
            Q(date_to_send=date_now.strftime('%Y-%m-%d 00:00:00.000'))
        )
        
        list_of_emails = []
        for data in today_mail:
            
            if data.frm_approver.is_action == True and data.form_code.status == 'Pending':
                
                # common details
                cr_link = f'{CR_FRONT_LINK}/{data.frm_approver.form_code}'

                auto_cancel_date = data.auto_cancel_date.strftime('%B %d, %Y')
                date_submitted_last_approver = data.date_submitted_last_approver.strftime('%B %d, %Y')
                cr_number = data.frm_approver.form_code.requested_to_template_id
                cr_name = data.frm_approver.form_code.requested_to_template_name
                company_requestedto = data.frm_approver.form_code.requested_to_company.name
                department_requestedto = data.frm_approver.form_code.requested_to_department.name
                priority_level = data.frm_approver.form_code.requested_to_priority
                form_status = data.frm_approver.form_code.status
                url = cr_link
                admin = 'Test'
                
                # approver details

                name = data.frm_approver.user.name
                recipient = data.frm_approver.user.email

                args_approver = [name, auto_cancel_date, date_submitted_last_approver,
                    cr_number, cr_name, company_requestedto, department_requestedto,
                    priority_level, form_status, url, recipient, admin]

                main_threading(args_approver, sender.routing_table_reminder_approver)
                list_of_emails.append(data.frm_approver.code)
                
                # requestor details
                
                requestor_name = data.frm_approver.form_code.requested_by_user.name
                requestor_recipient = data.frm_approver.form_code.requested_by_user.email

                args_requestor = [requestor_name, auto_cancel_date, date_submitted_last_approver,
                    name, cr_number, cr_name, company_requestedto,
                    department_requestedto, priority_level, form_status, url,
                    requestor_recipient, admin]
                
                main_threading(args_requestor, sender.routing_table_reminder_requestor)
                
                today_mail.update(date_to_send=next_day.strftime('%Y-%m-%d 00:00:00.000'))

        return Response(
            {"list of emails": list_of_emails},
            status=status.HTTP_200_OK
        )

