from app.entities import models
from rest_framework import viewsets, status
from rest_framework.response import Response
from django_filters import rest_framework as filters
from django_filters.rest_framework import DjangoFilterBackend
from rest_framework.filters import SearchFilter, OrderingFilter
from app.applicationlayer.cms.template.attachment.table_filters import AttachmentFilter
from app.applicationlayer.cms.template.attachment import serializers
from app.applicationlayer.utils import (
    CustomPagination, status_message_response
)


class ChangeRequestTemplateAttachmentsViewset(viewsets.ModelViewSet):

    queryset = models.ChangeRequestTemplateAttachments.objects.all()
    serializer_class = serializers.ChangeRequestTemplateAttachmentsSerializer
    pagination_class = CustomPagination
    lookup_field = "code"
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = AttachmentFilter
    ordering_fields = '__all__'
    search_fields = (
        'template_no', 'code',
        'file_name',
        'description',
        'uploaded_by__name'
    )

    def list(self, request, *args, **kwargs):
        
        page = self.paginate_queryset(self.queryset)
        
        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'List of Templates Attachments found',
                serializer.data
            )
            
            return self.get_paginated_response(message)

        serializer = self.get_serializer(self.queryset, many=True)

        return Response(
            serializer.data,
            status=status.HTTP_200_OK
        )
