from django.urls import path, include
from rest_framework import routers
from django.conf.urls import url

from app.applicationlayer.management.notification.views import NotificationsViewset

from app.applicationlayer.cms.form import views as crform_views
from app.applicationlayer.cms.allowed_company import views as allowed

# MASTERS
from app.applicationlayer.cms.master.company.views import ChangeRequestCompanyViewSet
from app.applicationlayer.cms.master.department.views import  ChangeRequestDepartmentViewSet
from app.applicationlayer.cms.master.account.views import  UserList
# MASTERS

# TEMPLATE 
from app.applicationlayer.cms.template.header import views as header
from app.applicationlayer.cms.template.approver import views as approver
from app.applicationlayer.cms.template.stakeholder import views as stakeholder
from app.applicationlayer.cms.template.details import views as details
from app.applicationlayer.cms.template.attachment import views as attachment
# TEMPLATE 

router = routers.DefaultRouter()

router.register(r'notifications', NotificationsViewset)

router.register(r'template', header.ChangeRequestTemplatesViewset)
router.register(r'template-approvers', approver.ChangeRequestTemplateApproversViewset)
router.register(r'template-attachments', attachment.ChangeRequestTemplateAttachmentsViewset)
router.register(r'template-stakeholders', stakeholder.ChangeRequestTemplateStakeholdersViewset)
router.register(r'template-details', details.ChangeRequestTemplateDetailsViewset)

router.register(r'form', crform_views.ChangeRequestFormsViewset)
router.register(r'form-approvers', crform_views.ChangeRequestFormApproversViewset)
router.register(r'form-stakeholders', crform_views.ChangeRequestFormStakeHoldersViewset)
router.register(r'form-attachments', crform_views.ChangeRequestFormAttachmentsViewset)
router.register(r'form-details', crform_views.ChangeRequestFormDetailsViewset)

# privilege CMS
router.register(r'allowed-companies', allowed.AllowedCompanyViewSet)
# privilege CMS

# filter endpoints under Allowed Companies table
router.register(r'companies', ChangeRequestCompanyViewSet)
router.register(r'departments', ChangeRequestDepartmentViewSet)
# filter endpoints under Allowed Companies table


urlpatterns = (
    path('', include(router.urls)),
    path('template-post/', header.ChangeRequestTemplatePost.as_view()),
    path('form-post/', crform_views.ChangeRequestFormPost.as_view()),
    # filter endpoints under Allowed Companies table
    path('user-list/', UserList.as_view(), name="User List"),
    # filter endpoints under Allowed Companies table
)
