from rest_framework import serializers
from app.entities.models import Department
from django.forms.models import model_to_dict


class AdminDepartmentSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['company'] = model_to_dict(instance.company)
        return ret

    class Meta:
        model = Department
        fields = '__all__'
        read_only_fields = (
            'created', 'createdby', 'modified', 'modifiedby', 'code',
        )
