from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from drf_writable_nested import WritableNestedModelSerializer
from django.forms.models import model_to_dict
from app.applicationlayer.cms.utils_cr import (get_account_details,
                                               get_dept_details,
                                               get_companies_details)


class ChangeRequestFormApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            user = instance.user
            
            user_details = get_account_details(user.code)
            name = user_details.values_list('name', flat=True)[0]
            dept_code = user_details.values_list('department', flat=True)[0]
            department_details = get_dept_details(dept_code)
            department = department_details.values_list('name', flat=True)[0]
            comp_code = department_details.values_list('company', flat=True)[0]
            company_details = get_companies_details(comp_code)
            company = company_details.values_list('name', flat=True)[0]
            
            ret['name'] = name
            ret['department'] = department
            ret['company'] = company
            
            # ret['company'] = model_to_dict(instance.user.department.company)
            # ret['department'] = model_to_dict(instance.user.department)
            # ret['name'] = model_to_dict(instance.user)
            
            return ret
        
        except Exception as e:
            ret['name'] = "none"
            ret['department'] = "none"
            ret['company'] = "none"
            return ret

    class Meta:
        model = models.ChangeRequestFormApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormStakeHoldersSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormStakeHolders
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormAttachmentsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormAttachments
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormDetailsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormDetails
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormHeaderSerializer(
    serializers.ModelSerializer
):
    frm_approvers = ChangeRequestFormApproversSerializer(
        many=True, read_only=True)
    frm_stakes = ChangeRequestFormStakeHoldersSerializer(
        many=True, read_only=True)
    frm_attachments = ChangeRequestFormAttachmentsSerializer(
        many=True, read_only=True)
    frm_details = ChangeRequestFormDetailsSerializer(
        many=True, read_only=True)

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            user = self.context['request'].user
            
            id_number = user.code
            current_level = models.ChangeRequestFormApprovers.objects.filter(
                Q(form_code=ret['form_code'])
                (Q(action='') | Q(action=None))
            ).order_by('level')

            if current_level.first()['user'] == id_number:
                if instance.status.lower() == 'rejected':
                    approver = 'No'
                elif instance.status.lower() == 'cancelled':
                    approver = 'No'
                elif instance.status.lower() == 'closed':
                    approver = 'No'
                else:
                    approver = 'Yes'
            else:
                approver = 'No'
            ret['action'] = approver
            return ret
        except Exception as e:
            ret['action'] = "No"
            return ret

    class Meta:
        model = models.ChangeRequestFormHeader
        # fields = '__all__'
        fields = ('form_code', 'requested_to_template_name', 'requested_to_objective',
                  'requested_to_target_date', 'requested_to_priority',
                  'description', 'created', 'cancel_date', 'status',
                  'company_desc', 'department_desc', 'requested_desc',
                  'requested_to_template_id', 'requested_to_company',
                  'requested_to_department', 'requested_to_user',
                  'requested_by_user', 'requested_by_department',
                  'template_no', 'frm_approvers', 'frm_stakes',
                  'frm_attachments', 'frm_details')

        read_only_fields = ['created', 'form_code']
