from rest_framework.views import APIView
from rest_framework.response import Response
from app.entities import enums


class UserTypeViewSet(APIView):

    def get(self, request, format=None):
        enums_super = enums.UserTypeEnum.SUPER_USER.value
        enums_OUA = enums.UserTypeEnum.OVERALL_USER_ADMIN.value
        enums_company = enums.UserTypeEnum.COMPANY_USER_ADMIN.value
        enums_department = enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.value
        enums_user = enums.UserTypeEnum.USER.value

        data = {
            "code": "200",
            "status": "success",
            "message": "list of user types",
            "results": 
            # [
                {
                    str(enums.UserTypeEnum.SUPER_USER.name) : enums_super,
                    str(enums.UserTypeEnum.OVERALL_USER_ADMIN.name) : enums_OUA,
                    str(enums.UserTypeEnum.COMPANY_USER_ADMIN.name) : enums_company, 
                    str(enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.name) : enums_department,
                    str(enums.UserTypeEnum.USER.name) : enums_user
                }
            # ]
        }

        # if self.request.user.user_type == enums_OUA:
        #     del data['Super user']
        #     del data['Overall user admin']
        # elif self.request.user.user_type == enums_company:
        #     del data['Super user']
        #     del data['Overall user admin']
        #     del data['Company user admin']
        if self.request.user.user_type != enums_super:
            del data['results'][str(enums.UserTypeEnum.SUPER_USER.name)]
            del data['results'][str(enums.UserTypeEnum.OVERALL_USER_ADMIN.name)]
            del data['results'][str(enums.UserTypeEnum.COMPANY_USER_ADMIN.name)]
            del data['results'][str(enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.name)]

        return Response(data)
