from rest_framework import serializers
from app.entities.models import User, Department
import ast
from django.contrib.auth.hashers import make_password, check_password
import re
from django.contrib.auth import authenticate
from django.forms.models import model_to_dict


class UserSerializer(serializers.ModelSerializer):

    # department = serializers.CharField(write_only=True)

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['department'] = model_to_dict(instance.department)
        ret['company'] = model_to_dict(instance.department.company)
        application = [data['id'] for data in instance.application.values()]
        ret['application'] = application

        return ret
    class Meta:
        model = User
        fields = (
            'id',
            'code', 'name',
            'username', 'contact_no',
            'email', 'default_app',
            'user_type', 'is_active',
            'doa', 'department'

        )

        read_only_fields = (
            'created', 'createdby', 'modified', 'modifiedby', 'code',
        )


class ChangeRequestList(serializers.ModelSerializer):

    class Meta:
        model = User
        fields = (
            'id',
            'code', 'name',
            'username', 'contact_no',
            'email', 'default_app',
            'user_type', 'is_active',
            'doa'

        )

class ChangePasswordSerializer(serializers.Serializer):
    old_password = serializers.CharField(required=True)
    new_password = serializers.CharField(required=True, min_length=6)
    new_password_confirm = serializers.CharField(required=True, min_length=6)

    def validate(self, data):

        instance = self.context.get('view').kwargs['pk']
        old_password = data['old_password']
        new_password = data['new_password']

        instance_password = User.objects.filter(
            id=instance
        )

        validated_password = check_password(
            old_password,
            instance_password.values().first()['password']
        )

        if validated_password:

            password = re.match(
                '([A-Za-z]+[0-9]|[0-9]+[A-Za-z])[A-Za-z0-9]*',
                data['new_password']
            )

            if password:

                new_password = make_password(data['new_password'])
                instance_password.update(password=new_password)
                instance = User.objects.get(id=instance)
                return instance

            elif len(new_password) <= 5:

                raise serializers.ValidationError(
                    'Password must be minimum of 6 characters'
                )

            else:

                raise serializers.ValidationError(
                    'password must be alpha numeric format'
                )
        else:
            raise serializers.ValidationError('Please ensure the old password is correct and both new password & confirm password are the same.')
