from django.urls import path, include
from rest_framework import routers
from django.conf.urls import url

from app.applicationlayer.management.notification.views import NotificationsViewset
from app.applicationlayer.cms.template import views as crtemplate_views
from app.applicationlayer.cms.form import views as crform_views
from app.applicationlayer.cms.allowed_company import views

router = routers.DefaultRouter()

router.register(r'notifications', NotificationsViewset)

router.register(r'template', crtemplate_views.ChangeRequestTemplatesViewset)
router.register(r'template-approvers', crtemplate_views.ChangeRequestTemplateApproversViewset)
router.register(r'template-attachments', crtemplate_views.ChangeRequestTemplateAttachmentsViewset)
router.register(r'template-stakeholders', crtemplate_views.ChangeRequestTemplateStakeHoldersViewset)
router.register(r'template-details', crtemplate_views.ChangeRequestTemplateDetailsViewset)

router.register(r'form', crform_views.ChangeRequestFormsViewset)
router.register(r'form-approvers', crform_views.ChangeRequestFormApproversViewset)
router.register(r'form-stakeholders', crform_views.ChangeRequestFormStakeHoldersViewset)
router.register(r'form-attachments', crform_views.ChangeRequestFormAttachmentsViewset)
router.register(r'form-details', crform_views.ChangeRequestFormDetailsViewset)
router.register(r'allowed-companies', views.AllowedCompanyViewSet)


urlpatterns = (
    path('', include(router.urls)),
    path('template-post/', crtemplate_views.ChangeRequestTemplatePost.as_view()),
    path('form-post/', crform_views.ChangeRequestFormPost.as_view()),
    # path('allowed-companies/', views.AllowedCompanyApiView.as_view()),
    path('user-list/', crtemplate_views.UserList.as_view(), name="User List"),
)
