from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from drf_writable_nested import WritableNestedModelSerializer


class ChangeRequestTemplateApproversSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateApprovers
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']


class ChangeRequestTemplateStakeHoldersSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateStakeHolders
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']
    

class ChangeRequestTemplateAttachmentsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateAttachments
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']


class ChangeRequestTemplateDetailsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateDetails
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']

# comment
class ChangeRequestTemplatesSerializer(
    WritableNestedModelSerializer
):
    tmp_approvers = ChangeRequestTemplateApproversSerializer(
        many=True, required=False)
    tmp_stakes = ChangeRequestTemplateStakeHoldersSerializer(
        many=True, required=False)
    tmp_attachments = ChangeRequestTemplateAttachmentsSerializer(
        many=True, required=False)
    tmp_details = ChangeRequestTemplateDetailsSerializer(
        many=True, required=False)

    class Meta:
        model = models.ChangeRequestTemplateHeader
        # fields = '__all__'
        fields = ('template_no', 'requested_to_template_name',
                  'requested_to_objective', 'requested_to_target_date',
                  'requested_to_priority', 'description', 'created',
                  'requested_to_template_id', 'requested_to_company',
                  'requested_to_department', 'requested_to_user',
                  'created_by_user', 'created_by_department', 'tmp_approvers',
                  'tmp_stakes', 'tmp_attachments', 'tmp_details')

        read_only_fields = ['created', 'archived_at', 'template_no']