from rest_framework import viewsets as meviewsets
from rest_framework.viewsets import ReadOnlyModelViewSet
from drf_renderer_xlsx.mixins import XLSXFileMixin
from drf_renderer_xlsx.renderers import XLSXRenderer
from app.entities.models import (
    User
)
# from app.applicationlayer.form_listing_ import headers
from app.applicationlayer.download.accounts.serializers import headers
from django.db.models import CharField, Value
from django.db.models import Q
from rest_framework.response import Response
from rest_framework.permissions import AllowAny
# from cms.applicationlayer.utilities import logged_user


class UserDownloadRequest(XLSXFileMixin, ReadOnlyModelViewSet):
    queryset = User.objects.all()
    serializer_class = headers
    renderer_classes = (XLSXRenderer,)
    filename = 'User List.xlsx'
    permission_classes = (AllowAny,)
    
    def list(self, request, *args, **kwargs):

        # id_number = request.user.code

        data = User.objects.all()
        serializer = headers(data=data, many=True)
        serializer.is_valid(raise_exception=False)
        return Response(serializer.data)

    column_header = {
        'titles': [
            'ID_NUMBER',
            'Name',
            'Email',
            'Contact Number',
            'Department',
            'Company'
        ],
        'column_width': [17, 30, 17],
        'height': 25,
        'style': {
            'alignment': {
                'horizontal': 'center',
                'vertical': 'center',
                'wrapText': False,
                'shrink_to_fit': True,
            },
            'border_side': {
                'border_style': 'thin',
                'color': 'FF000000',
            },
            'font': {
                'name': 'Arial',
                'size': 14,
                'bold': True,
                'color': 'FF000000',
            },
        },
    }
