-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.3.12-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             9.4.0.5125
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for rms_db
CREATE DATABASE IF NOT EXISTS `rms_db` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `rms_db`;

-- Dumping structure for table rms_db.applications
CREATE TABLE IF NOT EXISTS `applications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.applications: ~2 rows (approximately)
DELETE FROM `applications`;
/*!40000 ALTER TABLE `applications` DISABLE KEYS */;
INSERT INTO `applications` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`) VALUES
	(1, '2019-09-03 13:57:47.000000', 'admin', '2019-09-03 13:57:49.000000', 'admin', 'app', 'RMS');
/*!40000 ALTER TABLE `applications` ENABLE KEYS */;

-- Dumping structure for table rms_db.attachments
CREATE TABLE IF NOT EXISTS `attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.attachments: ~0 rows (approximately)
DELETE FROM `attachments`;
/*!40000 ALTER TABLE `attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.authtoken_token
CREATE TABLE IF NOT EXISTS `authtoken_token` (
  `key` varchar(40) NOT NULL,
  `created` datetime(6) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`key`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `authtoken_token_user_id_35299eff_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.authtoken_token: ~0 rows (approximately)
DELETE FROM `authtoken_token`;
/*!40000 ALTER TABLE `authtoken_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `authtoken_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_access_token
CREATE TABLE IF NOT EXISTS `auth_access_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `token` longtext NOT NULL,
  `passcode` varchar(255) NOT NULL,
  `timeout` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_access_token_user_id_c480a680_fk_auth_user_id` (`user_id`),
  CONSTRAINT `auth_access_token_user_id_c480a680_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_access_token: ~0 rows (approximately)
DELETE FROM `auth_access_token`;
/*!40000 ALTER TABLE `auth_access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_access_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group
CREATE TABLE IF NOT EXISTS `auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_group: ~0 rows (approximately)
DELETE FROM `auth_group`;
/*!40000 ALTER TABLE `auth_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group_permissions
CREATE TABLE IF NOT EXISTS `auth_group_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_group_permissions_group_id_permission_id_0cd325b0_uniq` (`group_id`,`permission_id`),
  KEY `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_group_permissions_group_id_b120cbf9_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_group_permissions: ~0 rows (approximately)
DELETE FROM `auth_group_permissions`;
/*!40000 ALTER TABLE `auth_group_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_permission
CREATE TABLE IF NOT EXISTS `auth_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `content_type_id` int(11) NOT NULL,
  `codename` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_permission_content_type_id_codename_01ab375a_uniq` (`content_type_id`,`codename`),
  CONSTRAINT `auth_permission_content_type_id_2f476e4b_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_permission: ~76 rows (approximately)
DELETE FROM `auth_permission`;
/*!40000 ALTER TABLE `auth_permission` DISABLE KEYS */;
INSERT INTO `auth_permission` (`id`, `name`, `content_type_id`, `codename`) VALUES
	(1, 'Can add log entry', 1, 'add_logentry'),
	(2, 'Can change log entry', 1, 'change_logentry'),
	(3, 'Can delete log entry', 1, 'delete_logentry'),
	(4, 'Can view log entry', 1, 'view_logentry'),
	(5, 'Can add permission', 2, 'add_permission'),
	(6, 'Can change permission', 2, 'change_permission'),
	(7, 'Can delete permission', 2, 'delete_permission'),
	(8, 'Can view permission', 2, 'view_permission'),
	(9, 'Can add group', 3, 'add_group'),
	(10, 'Can change group', 3, 'change_group'),
	(11, 'Can delete group', 3, 'delete_group'),
	(12, 'Can view group', 3, 'view_group'),
	(13, 'Can add content type', 4, 'add_contenttype'),
	(14, 'Can change content type', 4, 'change_contenttype'),
	(15, 'Can delete content type', 4, 'delete_contenttype'),
	(16, 'Can view content type', 4, 'view_contenttype'),
	(17, 'Can add session', 5, 'add_session'),
	(18, 'Can change session', 5, 'change_session'),
	(19, 'Can delete session', 5, 'delete_session'),
	(20, 'Can view session', 5, 'view_session'),
	(21, 'Can add Token', 6, 'add_token'),
	(22, 'Can change Token', 6, 'change_token'),
	(23, 'Can delete Token', 6, 'delete_token'),
	(24, 'Can view Token', 6, 'view_token'),
	(25, 'Can add user', 7, 'add_user'),
	(26, 'Can change user', 7, 'change_user'),
	(27, 'Can delete user', 7, 'delete_user'),
	(28, 'Can view user', 7, 'view_user'),
	(29, 'Can add application', 8, 'add_application'),
	(30, 'Can change application', 8, 'change_application'),
	(31, 'Can delete application', 8, 'delete_application'),
	(32, 'Can view application', 8, 'view_application'),
	(33, 'Can add attachment', 9, 'add_attachment'),
	(34, 'Can change attachment', 9, 'change_attachment'),
	(35, 'Can delete attachment', 9, 'delete_attachment'),
	(36, 'Can view attachment', 9, 'view_attachment'),
	(37, 'Can add company', 10, 'add_company'),
	(38, 'Can change company', 10, 'change_company'),
	(39, 'Can delete company', 10, 'delete_company'),
	(40, 'Can view company', 10, 'view_company'),
	(41, 'Can add entity log', 11, 'add_entitylog'),
	(42, 'Can change entity log', 11, 'change_entitylog'),
	(43, 'Can delete entity log', 11, 'delete_entitylog'),
	(44, 'Can view entity log', 11, 'view_entitylog'),
	(45, 'Can add permission', 12, 'add_permission'),
	(46, 'Can change permission', 12, 'change_permission'),
	(47, 'Can delete permission', 12, 'delete_permission'),
	(48, 'Can view permission', 12, 'view_permission'),
	(49, 'Can add role', 13, 'add_role'),
	(50, 'Can change role', 13, 'change_role'),
	(51, 'Can delete role', 13, 'delete_role'),
	(52, 'Can view role', 13, 'view_role'),
	(53, 'Can add status', 14, 'add_status'),
	(54, 'Can change status', 14, 'change_status'),
	(55, 'Can delete status', 14, 'delete_status'),
	(56, 'Can view status', 14, 'view_status'),
	(57, 'Can add user image', 15, 'add_userimage'),
	(58, 'Can change user image', 15, 'change_userimage'),
	(59, 'Can delete user image', 15, 'delete_userimage'),
	(60, 'Can view user image', 15, 'view_userimage'),
	(61, 'Can add role permission', 16, 'add_rolepermission'),
	(62, 'Can change role permission', 16, 'change_rolepermission'),
	(63, 'Can delete role permission', 16, 'delete_rolepermission'),
	(64, 'Can view role permission', 16, 'view_rolepermission'),
	(65, 'Can add module', 17, 'add_module'),
	(66, 'Can change module', 17, 'change_module'),
	(67, 'Can delete module', 17, 'delete_module'),
	(68, 'Can view module', 17, 'view_module'),
	(69, 'Can add department', 18, 'add_department'),
	(70, 'Can change department', 18, 'change_department'),
	(71, 'Can delete department', 18, 'delete_department'),
	(72, 'Can view department', 18, 'view_department'),
	(73, 'Can add auth token', 19, 'add_authtoken'),
	(74, 'Can change auth token', 19, 'change_authtoken'),
	(75, 'Can delete auth token', 19, 'delete_authtoken'),
	(76, 'Can view auth token', 19, 'view_authtoken');
/*!40000 ALTER TABLE `auth_permission` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user
CREATE TABLE IF NOT EXISTS `auth_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_login` datetime(6) DEFAULT NULL,
  `is_superuser` tinyint(1) NOT NULL,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(150) NOT NULL,
  `is_staff` tinyint(1) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `date_joined` datetime(6) NOT NULL,
  `user_type` varchar(100) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `contact_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `department_id` int(11) NOT NULL,
  `doa_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `username` (`username`),
  KEY `auth_user_department_id_ff5fa3db_fk_departments_id` (`department_id`),
  KEY `auth_user_doa_id_5076b369_fk_auth_user_id` (`doa_id`),
  CONSTRAINT `auth_user_department_id_ff5fa3db_fk_departments_id` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`),
  CONSTRAINT `auth_user_doa_id_5076b369_fk_auth_user_id` FOREIGN KEY (`doa_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user: ~1 rows (approximately)
DELETE FROM `auth_user`;
/*!40000 ALTER TABLE `auth_user` DISABLE KEYS */;
INSERT INTO `auth_user` (`id`, `last_login`, `is_superuser`, `first_name`, `last_name`, `is_staff`, `is_active`, `date_joined`, `user_type`, `code`, `name`, `username`, `password`, `contact_no`, `email`, `department_id`, `doa_id`) VALUES
	(2, NULL, 1, '', '', 1, 1, '2019-09-03 13:59:29.694560', 'USR', 'USER-20190903-0000002', '', 'admin', 'pbkdf2_sha256$150000$p5m04HY1xZDG$MhT7dJXjifenn6Wq6570gSKsCA4vQR8SWBqTi1v6AE8=', NULL, 'admin@tirsolution.com', 1, NULL);
/*!40000 ALTER TABLE `auth_user` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_application
CREATE TABLE IF NOT EXISTS `auth_user_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `application_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_application_user_id_application_id_4d89d44a_uniq` (`user_id`,`application_id`),
  KEY `auth_user_application_application_id_5c17d611_fk_applications_id` (`application_id`),
  CONSTRAINT `auth_user_application_application_id_5c17d611_fk_applications_id` FOREIGN KEY (`application_id`) REFERENCES `applications` (`id`),
  CONSTRAINT `auth_user_application_user_id_7b07e391_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_application: ~1 rows (approximately)
DELETE FROM `auth_user_application`;
/*!40000 ALTER TABLE `auth_user_application` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_application` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_groups
CREATE TABLE IF NOT EXISTS `auth_user_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_groups_user_id_group_id_94350c0c_uniq` (`user_id`,`group_id`),
  KEY `auth_user_groups_group_id_97559544_fk_auth_group_id` (`group_id`),
  CONSTRAINT `auth_user_groups_group_id_97559544_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`),
  CONSTRAINT `auth_user_groups_user_id_6a12ed8b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_groups: ~0 rows (approximately)
DELETE FROM `auth_user_groups`;
/*!40000 ALTER TABLE `auth_user_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_groups` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_images
CREATE TABLE IF NOT EXISTS `auth_user_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_user_images_user_id_7c29985d_fk_auth_user_id` (`user_id`),
  CONSTRAINT `auth_user_images_user_id_7c29985d_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_images: ~0 rows (approximately)
DELETE FROM `auth_user_images`;
/*!40000 ALTER TABLE `auth_user_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_images` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_user_permissions
CREATE TABLE IF NOT EXISTS `auth_user_user_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_user_permissions_user_id_permission_id_14a6b632_uniq` (`user_id`,`permission_id`),
  KEY `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_user_permissions: ~0 rows (approximately)
DELETE FROM `auth_user_user_permissions`;
/*!40000 ALTER TABLE `auth_user_user_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_user_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.companies
CREATE TABLE IF NOT EXISTS `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `contact_details` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.companies: ~0 rows (approximately)
DELETE FROM `companies`;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `contact_details`) VALUES
	(1, '2019-09-03 13:58:23.000000', 'admin', '2019-09-03 13:58:26.000000', 'admin', 'com', 'Oneberry', '132133');
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;

-- Dumping structure for table rms_db.departments
CREATE TABLE IF NOT EXISTS `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `company_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `departments_company_id_0d17e9ca_fk_companies_id` (`company_id`),
  CONSTRAINT `departments_company_id_0d17e9ca_fk_companies_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.departments: ~0 rows (approximately)
DELETE FROM `departments`;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `company_id`) VALUES
	(1, '2019-09-03 13:58:45.000000', 'admin', '2019-09-03 13:58:47.000000', 'admin', 'dept', 'SUPER', 1);
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_admin_log
CREATE TABLE IF NOT EXISTS `django_admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_time` datetime(6) NOT NULL,
  `object_id` longtext DEFAULT NULL,
  `object_repr` varchar(200) NOT NULL,
  `action_flag` smallint(5) unsigned NOT NULL,
  `change_message` longtext NOT NULL,
  `content_type_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `django_admin_log_content_type_id_c4bce8eb_fk_django_co` (`content_type_id`),
  KEY `django_admin_log_user_id_c564eba6_fk_auth_user_id` (`user_id`),
  CONSTRAINT `django_admin_log_content_type_id_c4bce8eb_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`),
  CONSTRAINT `django_admin_log_user_id_c564eba6_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.django_admin_log: ~0 rows (approximately)
DELETE FROM `django_admin_log`;
/*!40000 ALTER TABLE `django_admin_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_admin_log` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_content_type
CREATE TABLE IF NOT EXISTS `django_content_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_label` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `django_content_type_app_label_model_76bd3d3b_uniq` (`app_label`,`model`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.django_content_type: ~19 rows (approximately)
DELETE FROM `django_content_type`;
/*!40000 ALTER TABLE `django_content_type` DISABLE KEYS */;
INSERT INTO `django_content_type` (`id`, `app_label`, `model`) VALUES
	(1, 'admin', 'logentry'),
	(3, 'auth', 'group'),
	(2, 'auth', 'permission'),
	(6, 'authtoken', 'token'),
	(4, 'contenttypes', 'contenttype'),
	(8, 'entities', 'application'),
	(9, 'entities', 'attachment'),
	(19, 'entities', 'authtoken'),
	(10, 'entities', 'company'),
	(18, 'entities', 'department'),
	(11, 'entities', 'entitylog'),
	(17, 'entities', 'module'),
	(12, 'entities', 'permission'),
	(13, 'entities', 'role'),
	(16, 'entities', 'rolepermission'),
	(14, 'entities', 'status'),
	(7, 'entities', 'user'),
	(15, 'entities', 'userimage'),
	(5, 'sessions', 'session');
/*!40000 ALTER TABLE `django_content_type` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_migrations
CREATE TABLE IF NOT EXISTS `django_migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applied` datetime(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.django_migrations: ~20 rows (approximately)
DELETE FROM `django_migrations`;
/*!40000 ALTER TABLE `django_migrations` DISABLE KEYS */;
INSERT INTO `django_migrations` (`id`, `app`, `name`, `applied`) VALUES
	(1, 'contenttypes', '0001_initial', '2019-09-03 13:56:00.459683'),
	(2, 'contenttypes', '0002_remove_content_type_name', '2019-09-03 13:56:01.010479'),
	(3, 'auth', '0001_initial', '2019-09-03 13:56:02.330535'),
	(4, 'auth', '0002_alter_permission_name_max_length', '2019-09-03 13:56:04.319150'),
	(5, 'auth', '0003_alter_user_email_max_length', '2019-09-03 13:56:04.367164'),
	(6, 'auth', '0004_alter_user_username_opts', '2019-09-03 13:56:04.392185'),
	(7, 'auth', '0005_alter_user_last_login_null', '2019-09-03 13:56:04.410161'),
	(8, 'auth', '0006_require_contenttypes_0002', '2019-09-03 13:56:04.431025'),
	(9, 'auth', '0007_alter_validators_add_error_messages', '2019-09-03 13:56:04.452022'),
	(10, 'auth', '0008_alter_user_username_max_length', '2019-09-03 13:56:04.477030'),
	(11, 'auth', '0009_alter_user_last_name_max_length', '2019-09-03 13:56:04.503263'),
	(12, 'auth', '0010_alter_group_name_max_length', '2019-09-03 13:56:04.885175'),
	(13, 'auth', '0011_update_proxy_permissions', '2019-09-03 13:56:04.910697'),
	(14, 'entities', '0001_initial', '2019-09-03 13:56:10.130908'),
	(15, 'admin', '0001_initial', '2019-09-03 13:56:16.855573'),
	(16, 'admin', '0002_logentry_remove_auto_add', '2019-09-03 13:56:17.689160'),
	(17, 'admin', '0003_logentry_add_action_flag_choices', '2019-09-03 13:56:17.725163'),
	(18, 'authtoken', '0001_initial', '2019-09-03 13:56:17.958626'),
	(19, 'authtoken', '0002_auto_20160226_1747', '2019-09-03 13:56:18.971826'),
	(20, 'sessions', '0001_initial', '2019-09-03 13:56:19.329729');
/*!40000 ALTER TABLE `django_migrations` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_session
CREATE TABLE IF NOT EXISTS `django_session` (
  `session_key` varchar(40) NOT NULL,
  `session_data` longtext NOT NULL,
  `expire_date` datetime(6) NOT NULL,
  PRIMARY KEY (`session_key`),
  KEY `django_session_expire_date_a5c62663` (`expire_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.django_session: ~1 rows (approximately)
DELETE FROM `django_session`;
/*!40000 ALTER TABLE `django_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_session` ENABLE KEYS */;

-- Dumping structure for table rms_db.entity_logs
CREATE TABLE IF NOT EXISTS `entity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `row_id` int(11) NOT NULL,
  `fromValue` longtext DEFAULT NULL,
  `toValue` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.entity_logs: ~0 rows (approximately)
DELETE FROM `entity_logs`;
/*!40000 ALTER TABLE `entity_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `entity_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.modules
CREATE TABLE IF NOT EXISTS `modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `parent` int(11) NOT NULL,
  `sort_id` int(11) NOT NULL,
  `application_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `modules_application_id_f285bf5b_fk_applications_id` (`application_id`),
  CONSTRAINT `modules_application_id_f285bf5b_fk_applications_id` FOREIGN KEY (`application_id`) REFERENCES `applications` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.modules: ~7 rows (approximately)
DELETE FROM `modules`;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;

-- Dumping structure for table rms_db.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.permissions: ~0 rows (approximately)
DELETE FROM `permissions`;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.roles: ~0 rows (approximately)
DELETE FROM `roles`;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

-- Dumping structure for table rms_db.role_permissions
CREATE TABLE IF NOT EXISTS `role_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_permissions_permission_id_ad343843_fk_permissions_id` (`permission_id`),
  KEY `role_permissions_role_id_216516f2_fk_roles_id` (`role_id`),
  CONSTRAINT `role_permissions_permission_id_ad343843_fk_permissions_id` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`),
  CONSTRAINT `role_permissions_role_id_216516f2_fk_roles_id` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.role_permissions: ~0 rows (approximately)
DELETE FROM `role_permissions`;
/*!40000 ALTER TABLE `role_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.status_set
CREATE TABLE IF NOT EXISTS `status_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `ref` varchar(10) NOT NULL,
  `code` varchar(10) NOT NULL,
  `name` varchar(10) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.status_set: ~0 rows (approximately)
DELETE FROM `status_set`;
/*!40000 ALTER TABLE `status_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `status_set` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
