from rest_framework.views import APIView
from rest_framework.response import Response
from app.entities import enums


class AMSUserTypeViewSet(APIView):

    def get(self, request, format=None):
        manager_value = enums.AMSUserTypeEnum.MANAGER.value
        user_client_value = enums.AMSUserTypeEnum.USER_CLIENT.value
        support_value = enums.AMSUserTypeEnum.SUPPORT.value
        viewer_value = enums.AMSUserTypeEnum.VIEWER.value
        
        manager_key = str(enums.AMSUserTypeEnum.MANAGER.name).capitalize()
        user_client_key = str(enums.AMSUserTypeEnum.USER_CLIENT.name).replace('_', '/').title()
        support_key = str(enums.AMSUserTypeEnum.SUPPORT.name).capitalize()
        viewer_key = str(enums.AMSUserTypeEnum.VIEWER.name).capitalize()
        
        data = {
            "code": "200",
            "status": "success",
            "message": "list of ams user types",
            "results":
                {
                    manager_key : manager_value,
                    user_client_key : user_client_value,
                    support_key : support_value,
                    viewer_key : viewer_value
                }
        }

        return Response(data)