from django.urls import path, include
from rest_framework import routers
from django.conf.urls import url
from rest_framework.urlpatterns import format_suffix_patterns

from app.applicationlayer.ams.asset_group import views as assetgroup
from app.applicationlayer.ams.ams_privilege import views as amsprivilege
from app.applicationlayer.ams.ams_user_type.views import AMSUserTypeViewSet

router = routers.DefaultRouter()

router.register(r'asset-group', assetgroup.AssetGroupViewset)
router.register(r'ams-privilege', amsprivilege.AMSPrivilegeViewSet)

urlpatterns = [
    path('', include(router.urls)),
    url(r'^ams-user-types/$', AMSUserTypeViewSet.as_view(), name="ams-user-types"),
]