from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict
from django.db.models import Q


class AssetGroupSerializerList(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)

        asset_stocks = models.AMSAssetStock.objects.filter(asset_group=instance.code)
        
        asset_counter = 0
        asset_type_counter = 0
        for asset_stock in asset_stocks:
            asset_counter = asset_counter + models.AMSAsset.objects.filter(code=asset_stock.asset.code).count()
            asset_type_counter = asset_type_counter + 1
        
        ret['asset_type_count'] = asset_type_counter  # recheck
        ret['asset_count'] = instance.ams_asset_to_assetgroup.count() # recheck
        ret['asset_stock_count'] = instance.ams_asset_to_assetgroup.count()
        
        return ret

    class Meta:
        model = models.AMSAssetGroup
        fields = '__all__'
        read_only_fields = ['created', 'created_by', 'code']


class AssetGroupSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)

        asset_stocks = models.AMSAssetStock.objects.filter(asset_group=instance.code)
        
        asset_counter = 0
        asset_type_counter = 0
        for asset_stock in asset_stocks:
            asset_counter = asset_counter + models.AMSAsset.objects.filter(code=asset_stock.asset.code).count()
            asset_type_counter = asset_type_counter + 1
        
        ret['asset_type_count'] = asset_type_counter  # recheck
        ret['asset_count'] = instance.ams_asset_to_assetgroup.count() # recheck
        ret['asset_stock_count'] = instance.ams_asset_to_assetgroup.count()
        
        ret['own'] = instance.ams_asset_to_assetgroup.filter(acquisition_type='Owned').count()
        ret['loan'] = instance.ams_asset_to_assetgroup.filter(acquisition_type='Loan').count()
        ret['in_qty'] = instance.ams_asset_to_assetgroup.filter(status='In-Store').count()
        ret['out_qty'] = instance.ams_asset_to_assetgroup.filter(status='Deployed').count()
        ret['unavailable'] = instance.ams_asset_to_assetgroup.filter(
                                status__in=['Faulty', 'Returned', 'Written Off']
                                ).count()
        ret['in_store'] = instance.ams_asset_to_assetgroup.filter(status='In-Store').count()
        ret['deployed'] = instance.ams_asset_to_assetgroup.filter(status='Deployed').count()
        ret['returned'] = instance.ams_asset_to_assetgroup.filter(status='Returned').count()
        ret['written_off'] = instance.ams_asset_to_assetgroup.filter(status='Written Off').count()
        ret['faulty'] = instance.ams_asset_to_assetgroup.filter(status='Faulty').count()

        return ret

    class Meta:
        model = models.AMSAssetGroup
        fields = '__all__'
        read_only_fields = ['created', 'created_by', 'code']