from django.urls import path, include
from rest_framework import routers
from django.conf.urls import url

from app.applicationlayer.management.application.views import ApplicationViewSet
from app.applicationlayer.management.company.views import CompanyViewSet
from app.applicationlayer.management.department.views import DepartmentViewSet
from app.applicationlayer.management.module.views import ModuleViewSet
from app.applicationlayer.management.account.views import UserViewSet
from app.businesslayer.company.views import AdminCompanyViewSet
from app.applicationlayer.management.notification.views import NotificationsViewset
from app.applicationlayer.management.delegation.views import DelegationViewSet

from app.applicationlayer.download.accounts.views import UserDownloadRequest
from app.applicationlayer.download.department.views import DepartmentDownloadRequest
from app.applicationlayer.download.company.views import CompanyDownloadRequest


router = routers.DefaultRouter()

router.register(r'applications', ApplicationViewSet)
router.register(r'companies', CompanyViewSet)
router.register(r'departments', DepartmentViewSet)
router.register(r'modules', ModuleViewSet)
router.register(r'users', UserViewSet)
router.register(r'notifications', NotificationsViewset)
router.register(r'user-download', UserDownloadRequest)
router.register(r'department-download', DepartmentDownloadRequest)
router.register(r'company-download', CompanyDownloadRequest)
router.register(r'delegations', DelegationViewSet)

urlpatterns = (
    path('', include(router.urls)),
)
