from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict
from django.db.models import Q


class AssetGroupSerializerList(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)

        ret['asset_type_count'] = instance.ams_asset_to_assetgroup.values('asset__asset_type').distinct().count()
        ret['asset_count'] = instance.ams_asset_to_assetgroup.values('asset').distinct().count()
        ret['asset_stock_count'] = instance.ams_asset_to_assetgroup.count()
        
        return ret

    class Meta:
        model = models.AMSAssetGroup
        fields = '__all__'
        read_only_fields = ['created', 'code']


class AssetGroupSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)

        ret['asset_type_count'] = instance.ams_asset_to_assetgroup.values('asset__asset_type').distinct().count()
        ret['asset_count'] = instance.ams_asset_to_assetgroup.values('asset').distinct().count()
        ret['asset_stock_count'] = instance.ams_asset_to_assetgroup.count()
        
        ret['own'] = instance.ams_asset_to_assetgroup.filter(acquisition_type='Owned').count()
        ret['loan'] = instance.ams_asset_to_assetgroup.filter(acquisition_type='Loan').count()
        ret['in_qty'] = instance.ams_asset_to_assetgroup.filter(status='In-Store').count()
        ret['out_qty'] = instance.ams_asset_to_assetgroup.filter(status='Deployed').count()
        ret['unavailable'] = instance.ams_asset_to_assetgroup.filter(
                                status__in=['Faulty', 'Returned', 'Written Off']
                                ).count()
        ret['in_store'] = instance.ams_asset_to_assetgroup.filter(status='In-Store').count()
        ret['deployed'] = instance.ams_asset_to_assetgroup.filter(status='Deployed').count()
        ret['returned'] = instance.ams_asset_to_assetgroup.filter(status='Returned').count()
        ret['written_off'] = instance.ams_asset_to_assetgroup.filter(status='Written Off').count()
        ret['faulty'] = instance.ams_asset_to_assetgroup.filter(status='Faulty').count()

        return ret

    class Meta:
        model = models.AMSAssetGroup
        fields = '__all__'
        read_only_fields = ['created', 'code']