from app.entities import models
from rest_framework import viewsets, status
from rest_framework.response import Response
from django_filters import rest_framework as filters
from django_filters.rest_framework import DjangoFilterBackend
from rest_framework.filters import SearchFilter, OrderingFilter
from app.applicationlayer.ams.audit_trail.table_filters import AuditTrailFilter
from app.applicationlayer.ams.audit_trail import serializers
from app.applicationlayer.utils import (
    CustomPagination, status_message_response
)
from app.helper import decorators
from django.db import transaction
from rest_framework.decorators import action
from app.applicationlayer.utils import model_to_dict
from app.applicationlayer.utils import log_save, enums
from app.applicationlayer.utils import model_to_dict
from django.db import IntegrityError


class AMSAuditTrailViewset(viewsets.ModelViewSet):

    queryset = models.AMSAuditTrail.objects.all()
    serializer_class = serializers.AuditTrailSerializer
    pagination_class = CustomPagination
    lookup_field = "code"
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    ordering_fields = '__all__'
    search_fields = (
        'code', 'name'
    )

    def create(self, request, *args, **kwargs):
        form = request.data
        form['created_by'] = request.user.code
        
        serializer = self.get_serializer(data=form)
        serializer.is_valid(raise_exception=True)
        self.perform_create(serializer)

        message = status_message_response(
            201, 'success',
            'New Audit Trail created', serializer.data
        )

        return Response(
            message
        )
    
    def list(self, request, *args, **kwargs):

        queryset = self.filter_queryset(self.get_queryset())

        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'List of Asset Types found!',
                serializer.data
            )

            return self.get_paginated_response(message)

        serializer = self.get_serializer(self.queryset, many=True)

        return Response(
            serializer.data,
            status=status.HTTP_200_OK
        )


def audit_trail_create(name, desc, asset_stock, created_by):
    try:
        models.AMSAuditTrail.objects.create(
                name=name,
                desciption=desc,
                asset_stock=asset_stock,
                created_by=created_by
            )
        
        return True

    except Exception as e:
        message = {
            'code': 500,
            'status': 'failed',
            'message': 'Request was not able to process' + str(e.__class__)
        }
        return Response(message,
                        status=status.HTTP_500_INTERNAL_SERVER_ERROR)