from django.shortcuts import render

from app.entities import models

from datetime import datetime

from rest_framework.response import Response
from rest_framework import status, views

from rest_framework.decorators import action
from django.http import Http404

from django.db.models import Q
from app.applicationlayer.cms.utils_cr import (
    number_generator, crhistory_save, entity_log_bulk
)
from app.applicationlayer.utils import model_to_dict
from app.entities import enums, models
from app.applicationlayer.utils import log_save, CustomPagination

import itertools
from operator import itemgetter


def tmp_add_edit_delete(tmp_request_body,
                        queryset,
                        enum_type,
                        serializer_data,
                        partial,
                        self,
                        template_no):
    
    # delete ids not in request body
    request_ids = [i['id'] for i in tmp_request_body if "id" in i]

    delete_query = queryset.objects.filter(
        template_no=template_no
    ).exclude(
        id__in=request_ids
    )

    if delete_query.count() > 0:
        entity_log_bulk(
            delete_query,
            enum_type,
            queryset
        )

    # update or create
    for i in tmp_request_body:
        if "id" in i:
            if not i['id'] is None:
                tmp_instance = queryset.objects.get(
                    pk=i['id']
                )
                tmp_code = {
                    "template_no": template_no
                }
                data = {**i, **tmp_code}
                
                serializer = serializer_data(tmp_instance,
                                            data=data,
                                            partial=partial)

                serializer.is_valid(raise_exception=True)
                old_instance = model_to_dict(tmp_instance)
                
                self.perform_update(serializer)
                new_instance = serializer.data
                
                log_save(
                    enums.LogEnum.UPDATE.value,
                    enum_type,
                    i['id'],
                    old_instance,
                    new_instance
                )

            else:
                tmp_code = {
                    "template_no": template_no
                }
                data = {**i, **tmp_code}
                serializer = serializer_data(data=data)
                serializer.is_valid(raise_exception=True)

                self.perform_create(serializer)
                new_instance = serializer.data
                try:
                    log_save(
                        enums.LogEnum.ADD.value,
                        enum_type,
                        old_instance['id'],
                        '',
                        new_instance
                    )
                except Exception as e:
                    log_save(
                        enums.LogEnum.ADD.value,
                        enum_type,
                        new_instance['id'],
                        '',
                        new_instance
                    )

        else:
            tmp_code = {
                "template_no": template_no
            }
            data = {**i, **tmp_code}
            serializer = serializer_data(data=data)
            serializer.is_valid(raise_exception=True)

            self.perform_create(serializer)
            new_instance = serializer.data
            try:
                log_save(
                    enums.LogEnum.ADD.value,
                    enum_type,
                    old_instance['id'],
                    '',
                    new_instance
                )
            except Exception as e:
                log_save(
                    enums.LogEnum.ADD.value,
                    enum_type,
                    new_instance['id'],
                    '',
                    new_instance
                )

    return True


# Check if routing table has Vendor and Requestor
def validation_existing_vendor_requestor(approvers):

    approvers_data = sorted(approvers,
                            key=itemgetter('level'))[-2:]
 
    if (approvers_data[0]['delegation'] == 'DELEGATION-20191119-0000002' and
            approvers_data[1]['delegation'] == 'DELEGATION-20191119-0000001'):
        return True
    else:
        return False


# Check if routing table has atleast 1 approver
def validation_existing_approver(approvers):
    counter = 0
    for approver in approvers:
        # count all delegation not equal to Requestor and Vendor
        if approver['delegation'] not in ['DELEGATION-20191119-0000002',
                                          'DELEGATION-20191119-0000001']:
            counter = counter + 1
            return counter
    return counter


# Check if a user has multiple same level in routing table
def validation_approver_same_level(approvers):

    data_list_appr = []

    for approver in approvers:
        if 'user' in approver and 'level' in approver:
            if not approver['user'] is None:
                data_list_appr.append(approver)
                
    # add checking
    approvers_data = sorted(data_list_appr,
                            key=itemgetter('level', 'user'))
    
    for key, value in itertools.groupby(approvers_data,
                                        key=itemgetter('level', 'user')):
        count_user_same_level = 0
        for i in value:
            count_user_same_level = count_user_same_level + 1
            user_code = i.get('user')
        if count_user_same_level > 1:
            user = models.User.objects.get(code=user_code)
            user_name = user.name
            
            return user_name

    return None


# Check if poc is assigned to another delegation other than Vendor
def validation_poc_vendor_only(poc, approvers):
    
    validate = False

    for approver in approvers:
        if 'user' in approver and 'delegation' in approver:
            if poc == approver['user']:
                if not approver['delegation'] == 'DELEGATION-20191119-0000002':
                    validate = True
    return validate
                

# Check if level if Vendor delegation has same level with other delegation
def validation_vendor_unique_level(approvers):

    validate = 0
    data_level = []

    for approver in approvers:
        if 'delegation' in approver:
            if approver['delegation'] == 'DELEGATION-20191119-0000002':
                data_level.append(approver['level'])
    
    for approver in approvers:
        if 'delegation' in approver:
            if not approver['delegation'] is None:
                if approver['level'] in data_level:
                    if not approver['delegation'] == 'DELEGATION-20191119-0000002':
                        validate = approver['level']
    return validate
