from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class ChangeRequestFormApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            ret['company'] = {
                "id": instance.user.department.company.id,
                "code": instance.user.department.company.code,
                "name": instance.user.department.company.name
            }
            ret['department'] = {
                "id": instance.user.department.id,
                "code": instance.user.department.code,
                "name": instance.user.department.name
            }
            user_object = {
                "id": instance.user.id,
                "name": instance.user.name,
                "username": instance.user.username,
                "code": instance.user.code,
                "email": instance.user.email,
                "contact_no": instance.user.contact_no
            }
            ret['user'] = user_object
            ret['delegation'] = {
                "id": instance.delegation.id,
                "code": instance.delegation.code,
                "name": instance.delegation.name
            }
            
            if instance.form_code.status == 'Draft':
                if instance.tmp_approver:
                    
                    if instance.tmp_approver.user or instance.tmp_approver.delegation.name.lower() == 'requestor':
                        ret['editable_user'] = False
                    else:
                        ret['editable_user'] = True

                    if instance.tmp_approver.company or instance.tmp_approver.delegation.name.lower() == 'requestor':
                        ret['editable_comp'] = False
                    else:
                        ret['editable_comp'] = True

                    if instance.tmp_approver.department or instance.tmp_approver.delegation.name.lower() == 'requestor':
                        ret['editable_dept'] = False
                    else:
                        ret['editable_dept'] = True
                    # not instance.tmp_approver.delegation.code  or 
                    if instance.tmp_approver.delegation:
                        ret['editable_deleg'] = False
                    else:
                        ret['editable_deleg'] = True

                    # print(instance.tmp_approver.delegation.name)
                    # comment
                    # if instance.tmp_approver.delegation.name.lower() == 'requestor':
                    #     ret['editable_user'] = False
                    #     ret['editable_comp'] = False
                    #     ret['editable_dept'] = False
                    #     ret['editable_deleg'] = False

                else:
                    ret['editable_user'] = True
                    ret['editable_comp'] = True
                    ret['editable_dept'] = True
                    ret['editable_deleg'] = True
            else:
                ret['editable_user'] = False
                ret['editable_comp'] = False
                ret['editable_dept'] = False
                ret['editable_deleg'] = False

            return ret
        
        except Exception as e:
            
            if instance.form_code.status == 'Draft':
                if instance.tmp_approver:
                    
                    if instance.tmp_approver.user or instance.tmp_approver.delegation.name.lower() == 'requestor':
                        ret['editable_user'] = False
                    else:
                        ret['user'] = None
                        ret['editable_user'] = True

                    if instance.tmp_approver.company or instance.tmp_approver.delegation.name.lower() == 'requestor':
                        ret['company'] = {
                           "id": instance.tmp_approver.company.id,
                           "code": instance.tmp_approver.company.code,
                           "name": instance.tmp_approver.company.name
                        }
                        
                        ret['editable_comp'] = False
                    else:
                        ret['company'] = None
                        ret['editable_comp'] = True

                    if instance.tmp_approver.department or instance.tmp_approver.delegation.name.lower() == 'requestor':
                        ret['department'] = {
                            "id": instance.tmp_approver.department.id,
                            "code": instance.tmp_approver.department.code,
                            "name": instance.tmp_approver.department.name
                        }
                        ret['editable_dept'] = False
                    else:
                        ret['department'] = None
                        ret['editable_dept'] = True

                    if instance.tmp_approver.delegation:
                        
                        ret['delegation'] = {
                            "id": instance.tmp_approver.delegation.id,
                            "code": instance.tmp_approver.delegation.code,
                            "name": instance.tmp_approver.delegation.name
                        }
                        ret['editable_deleg'] = False
                    else:
                        ret['delegation'] = None
                        ret['editable_deleg'] = True

                    # print(instance.tmp_approver.delegation.name)
                    # if instance.tmp_approver.delegation.name.lower() == 'requestor':
                    #     ret['editable_user'] = False
                    #     ret['editable_comp'] = False
                    #     ret['editable_dept'] = False
                    #     ret['editable_deleg'] = False

                else:
                    ret['editable_user'] = True
                    ret['editable_comp'] = True
                    ret['editable_dept'] = True
                    ret['editable_deleg'] = True
            else:
                ret['editable_user'] = False
                ret['editable_comp'] = False
                ret['editable_dept'] = False
                ret['editable_deleg'] = False

            return ret

    class Meta:
        model = models.ChangeRequestFormApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']

