from django.shortcuts import render
from app.entities import models
from app.applicationlayer import paginators

from datetime import datetime

from rest_framework.response import Response
from rest_framework import status, views

from rest_framework.decorators import action
from django.http import Http404

from django.db.models import Q

from app.applicationlayer.cms.utils_cr import (
    number_generator, crhistory_save, entity_log_bulk,
    crhistory_log_bulk_delete
)
from app.applicationlayer.utils import model_to_dict
from app.entities import enums, models
from app.applicationlayer.utils import log_save, CustomPagination
from app.applicationlayer.cms.template import serializers
from django.db.models import Min


def list_by_user(user_id_number):
    try:

        priviledgeCrs = models.AllowedCompany.objects.filter(
            Q(id_number=user_id_number) &
            Q(view_all_change_request=True)
        ).values('group_pivots')
        
        return_queryset = models.ChangeRequestFormHeader.objects.filter(
            (Q(frm_approvers__user__code=user_id_number) |
            Q(frm_stakes__user__code=user_id_number) |
            Q(requested_by_user=user_id_number) |
            Q(requested_to_department__in=priviledgeCrs)) &
            Q(is_active=True)
        ).exclude(
                Q(status__icontains='Draft') &
                ~Q(requested_by_user=user_id_number)
        ).distinct()

        return return_queryset

    except Exception as e:
        
        return_queryset = None

        return return_queryset

def list_by_user_archived(user_id_number):
    try:

        priviledgeCrs = models.AllowedCompany.objects.filter(
            Q(id_number=user_id_number) &
            Q(view_all_change_request=True)
        ).values('group_pivots')
        
        return_queryset = models.ChangeRequestFormHeader.objects.filter(
            (Q(frm_approvers__user__code=user_id_number) |
            Q(frm_stakes__user__code=user_id_number) |
            Q(requested_by_user=user_id_number) |
            Q(requested_to_department__in=priviledgeCrs)) &
            Q(is_active=False)
        ).exclude(
                Q(status__icontains='Draft') &
                ~Q(requested_by_user=user_id_number)
        ).distinct()

        return return_queryset

    except Exception as e:
        
        return_queryset = None

        return return_queryset

def list_by_user_without_dept(user_id_number):
    try:
        return_queryset = models.ChangeRequestFormHeader.objects.filter(
            (Q(frm_approvers__user__code=user_id_number) |
            Q(frm_stakes__user__code=user_id_number) |
            Q(requested_by_user=user_id_number)) &
            Q(is_active=True)
        ).exclude(
                Q(status__icontains='Draft') &
                ~Q(requested_by_user=user_id_number)
        ).distinct()
        
        return return_queryset

    except Exception as e:
        
        return_queryset = None

    return return_queryset


def filter_base(base_queryset,
                company_requested_to,
                department_requested_to,
                date_modified_from,
                date_modified_to,
                date_required_from,
                date_required_to,
                form_type):

    return_queryset = base_queryset
    
    try:

        if company_requested_to:
            return_queryset = return_queryset.filter(
                requested_to_company__exact=company_requested_to)

        if department_requested_to:
            return_queryset = return_queryset.filter(
                requested_to_department__exact=department_requested_to)

        if form_type == 'open':
            return_queryset = return_queryset.filter(~Q(status='Completed & Accepted'))
        elif form_type == 'closed':
            return_queryset = return_queryset.filter(status='Completed & Accepted')

        date_modified = []
        #comment
        if date_modified_from and date_modified_to:        
            for query in return_queryset:
                created = datetime.strftime(query.created, "%Y-%m-%d")
                
                if created >= date_modified_from and created <= date_modified_to:
                    date_modified.append(query.id)

            return_queryset = return_queryset.filter(id__in=date_modified)
            
        date_required = []
        
        if date_required_from and date_required_to:
            for query in return_queryset:
                if query.requested_to_target_date:
                    requested_to_target_date = datetime.strftime(
                        query.requested_to_target_date,
                        "%Y-%m-%d")
                    
                    if requested_to_target_date >= date_required_from and requested_to_target_date <= date_required_to:
                        date_required.append(query.id)

            return_queryset = return_queryset.filter(
                id__in=date_required
            )
                
        return_queryset

    except Exception as e:
        pass

    return return_queryset


def filter_overdue(base_queryset):

    return_queryset = base_queryset

    try:

        now = datetime.now()
        overdue = []
        
        for query in return_queryset:
            if (query.requested_to_target_date < now):
                overdue.append(query.form_code)

        return_queryset = return_queryset.filter(
            form_code__in=overdue
        )

    except Exception as e:
        pass

    return return_queryset


def filter_status(base_queryset,
                  status):

    return_queryset = base_queryset
    
    try:

        if status == 'closed':
            status = 'Completed & Accepted'

        if status:
            return_queryset = return_queryset.filter(
                status__iexact=status
            )

        return_queryset

    except Exception as e:
        pass

    return return_queryset


def filter_awaiting(base_queryset,
                    user_id_number):

    return_queryset = base_queryset
    
    try:
        awaiting_included = []
                
        for query in return_queryset:
            
            next_approvers = models.ChangeRequestFormApprovers.objects.filter(
                Q(form_code=query.form_code) &
                Q(is_action=True)
            ).order_by("level")
            
            for next_approver in next_approvers:
                if next_approver.user.code == user_id_number:
                    awaiting_included.append(query.form_code)
                    
        return_queryset = return_queryset.filter(
            form_code__in=awaiting_included
        ).exclude(
            (Q(status__icontains='Rejected') |
            Q(status__icontains='Completed & Accepted') |
            Q(status__icontains='Cancelled') |
            Q(status__icontains='Draft'))
        )
    
    except Exception as e:
        pass

    return return_queryset


def form_add_edit_delete(form_request_body,
                         queryset,
                         entity,
                         serializer_data,
                         partial,
                         self,
                         form_code,
                         batch_no,
                         main_action):
    
    # delete ids not in request body
    request_ids = [i['id'] for i in form_request_body if "id" in i]

    delete_query = queryset.objects.filter(
        form_code=form_code
    ).exclude(
        id__in=request_ids
    )

    if delete_query.count() > 0:
        crhistory_log_bulk_delete(delete_query,
                                  entity,
                                  queryset,
                                  form_code,
                                  batch_no,
                                  main_action
        )

    # update or create
    for i in form_request_body:
        if "id" in i:
            frm_instance = queryset.objects.get(
                pk=i['id']
            )

            frm_code = {
                "form_code": form_code
            }
            data = {**i, **frm_code}

            serializer = serializer_data(frm_instance,
                                         data=data,
                                         partial=partial,
                                         context={"request":self.request})

            serializer.is_valid(raise_exception=True)
            old_instance = model_to_dict(frm_instance)
            self.perform_update(serializer)
            new_instance = serializer.data
            # comment
            crhistory_save(
                batch_no,
                main_action,
                enums.CREnum.UPDATE.value,
                entity,
                form_code,
                old_instance,
                new_instance
            )

        else:
            frm_code = {
                "form_code": form_code
            }
            data = {**i, **frm_code}
            serializer = serializer_data(data=data,
                                         context={"request":self.request})
            serializer.is_valid(raise_exception=True)

            self.perform_create(serializer)
            new_instance = serializer.data
            
            crhistory_save(
                batch_no,
                main_action,
                enums.CREnum.ADD.value,
                entity,
                form_code,
                None,
                new_instance
            )

    return True


def attachment_add_edit_delete(form_request_body,
                               queryset,
                               entity,
                               serializer_data,
                               partial,
                               self,
                               form_code,
                               batch_no,
                               main_action,
                               id_number):
    
    # delete ids not in request body
    request_ids = [i['id'] for i in form_request_body if "id" in i]

    delete_query = queryset.objects.filter(
        form_code=form_code
    ).exclude(
        id__in=request_ids
    )

    if delete_query.count() > 0:
        crhistory_log_bulk_delete(delete_query,
                                  entity,
                                  queryset,
                                  form_code,
                                  batch_no,
                                  main_action
        )

    # update or create
    for i in form_request_body:
        if "id" in i:
            frm_instance = queryset.objects.get(
                pk=i['id']
            )

            data_old = {
                'id': frm_instance.id,
                'attachment_type': frm_instance.attachment_type,
                'attachment_name': frm_instance.attachment_name,
                'file_name': frm_instance.file_name,
                'description': frm_instance.description,
                'file_upload': frm_instance.file_upload.id
            }

            data_new = {
                'id': i['id'],
                'attachment_type': i['attachment_type'],
                'attachment_name': i['attachment_name'],
                'file_name': i['file_name'],
                'description': i['description'],
                'file_upload': i['file_upload']
            }
            
            frm_code = {
                "form_code": form_code,
                "uploaded_by": id_number
            }
            data = {**i, **frm_code}
            
            old_instance = model_to_dict(frm_instance)
            
            if not data_old == data_new:
                serializer = serializer_data(frm_instance,
                                data=data,
                                partial=partial,
                                context={"request":self.request})

                serializer.is_valid(raise_exception=True)

                self.perform_update(serializer)
                new_instance = serializer.data
                # 
                
                # print(new_instance)
                crhistory_save(
                    batch_no,
                    main_action,
                    enums.CREnum.UPDATE.value,
                    entity,
                    form_code,
                    old_instance,
                    new_instance
                )

        else:
            frm_code = {
                "form_code": form_code,
                "uploaded_by": id_number
            }
            data = {**i, **frm_code}
            serializer = serializer_data(data=data,
                                         context={"request":self.request})
            serializer.is_valid(raise_exception=True)

            self.perform_create(serializer)
            new_instance = serializer.data
            
            crhistory_save(
                batch_no,
                main_action,
                enums.CREnum.ADD.value,
                entity,
                form_code,
                None,
                new_instance
            )

    return True