from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class AssetGroupSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)

        asset_stocks = models.AMSAssetStock.objects.filter(asset_group=instance.code)
        
        asset_counter = 0
        asset_type_counter = 0
        for asset_stock in asset_stocks:
            asset_counter = asset_counter + models.AMSAsset.objects.filter(code=asset_stock.asset.code).count()
            asset_type_counter = asset_type_counter + 1
        
        ret['asset_type_count'] = asset_type_counter
        ret['asset_count'] = asset_counter
        ret['asset_stock_count'] = instance.ams_asset_to_assetgroup.count()
        
        return ret

    class Meta:
        model = models.AMSAssetGroup
        fields = '__all__'
        read_only_fields = ['created', 'created_by', 'code']